<?php
spl_autoload_register(function ($class) {
    $baseDir = __DIR__; // Корень проекта

    // Преобразуем namespace в путь
    $classPath = str_replace('\\', '/', $class) . '.php';

    // Ищем файл
    $file = findFileRecursive($baseDir, $classPath);

    if ($file) {
        require_once $file;
    } else {
        error_log("Class $class not found in autoloader.");
    }
});

/**
 * Рекурсивный поиск файла в папках
 */
function findFileRecursive($dir, $fileName) {
    if (!is_dir($dir)) {
        throw new UnexpectedValueException("Directory not found: $dir");
    }

    foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir)) as $file) {
        if ($file->isFile() && $file->getFilename() === basename($fileName)) {
            return $file->getPathname();
        }
    }
    
    return false;
}
