<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    header('Content-Type: application/json');

    // Обработка вывода до JSON
    ob_start();

    // Определение пути к директории движка
    define('ENGINE_DIR', __DIR__ . '/engine');

    // Загрузка конфигурационного файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Подключение к базе данных
    require_once(ENGINE_DIR . '/data/dbconfig.php');

    function check_license($license_key, $current_domain)
    {
        global $dbhost, $dbuser, $dbpasswd, $db_connect;

        $stored_domain = $db_connect->get("license_keys", "domain", ["license_key" => $license_key]);

        if ($stored_domain) {
            // Удаление "www." из доменов для сравнения
            $current_domain = preg_replace('/^www\./', '', $current_domain);
            $stored_domain = preg_replace('/^www\./', '', $stored_domain);

            if ($stored_domain === $current_domain) {
                // Получение версии и даты создания
                $license_data = $db_connect->get("license_keys", ["version", "created_date"], ["license_key" => $license_key]);

                return [
                    'status' => 'valid',
                    'version' => $license_data['version'],
                    'created_date' => $license_data['created_date']
                ];
            } else {
                return ['status' => 'invalid', 'error' => 'Лицензионный ключ предназначен для другого домена.'];
            }
        } else {
            return ['status' => 'invalid', 'error' => 'Лицензионный ключ не найден.'];
        }
    }

    // Получение данных из запроса
    $license_key = $_POST['license_key'] ?? null;
    $current_domain = $_POST['domain'] ?? null;

    if (!$license_key || !$current_domain) {
        echo json_encode(['status' => 'error', 'message' => 'Некорректные параметры запроса.']);
        ob_end_clean();
        exit;
    }

    // Проверка лицензии
    $result = check_license($license_key, $current_domain);

    // Очищаем буфер вывода перед отправкой JSON
    ob_clean();
    echo json_encode($result);
    exit;