<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    session_start();

    global $db_connect;

    $messages = $db_connect->select("group_messages", "*", [
        "group_id" => 1,
    ]) ?? [];



    foreach ($messages as $key => &$message) {
        $deleted = $db_connect->select("chat_deletions", "*", [
            "AND" => [
                "OR" => [
                    "AND #1" => [
                        "user_id" => $_SESSION["user_id"],
                        "chat_id" => $message["id"]
                    ],
                    "AND #2" => [
                        "user_id" => $message["sender_id"],
                        "chat_id" => $message["id"]
                    ],
                ],
            ],

            "chat_type" => "live-chat"
            // "ORDER" => ["created_at" => "ASC"],
        ]) ?? [];

        foreach ($deleted as $keyM => $deletedMessage) {
            if (!empty($deletedMessage) && $_SESSION["user_id"] == $deletedMessage["user_id"]) {
                unset($messages[$key]);
            } else if (!empty($deletedMessage)) {
                $message["deleted"] = true;
            }

        }


        if ($message["sender_id"] == $_SESSION["user_id"]) {
            $message["from"] = "me";
        } else {
            $message["from"] = "you";
        }

        $message["sender_name"] = $db_connect->get("users", "name", ["id" => $message["sender_id"]]);
        $message["sender_avatar"] = $db_connect->get("users", "avatar", ["id" => $message["sender_id"]]);
        $message["repliedMessage"] = $db_connect->get("group_messages", "*", ["id" => $message["reply_to_id"]]) ?? [];


        if (!empty($message["file_path"])) {
            $message["file_name"] = explode("/", $message["file_path"]);
            $message["file_name"] = end($message["file_name"]);
        }

    }
    unset($message);

    $messages = array_values($messages);

    echo json_encode($messages);