<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    global $db_connect;

    session_start();
    $userId = $_SESSION['user_id'] ?? 0;
    $shopId = $_POST['shop_id'] ?? 0;

    $shop = $db_connect->get("shops", "*", ["shop_id" => $shopId, "owner_id" => $userId]);
    if (!$shop) {
        echo json_encode(['success' => 0, 'error' => 'Магазин не найден или нет прав']);
        exit;
    }

    // Получаем данные из формы
    $product_id = intval($_POST['product_id'] ?? 0);
    $goal_amount = floatval($_POST['goal_amount'] ?? 0);
    $date_start = $_POST['date_start'] ?? null;
    $date_end = $_POST['date_end'] ?? null;
    $min_participants = intval($_POST['min_participants'] ?? 1);
    $max_participants = $_POST['max_participants'] ? intval($_POST['max_participants']) : null;

    // Проверки
    if ($product_id <= 0 || $goal_amount <= 0) {
        echo json_encode(['success' => 0, 'error' => 'Некорректные данные']);
        exit;
    }
    if ($max_participants && $min_participants > $max_participants) {
        echo json_encode(['success' => 0, 'error' => 'Мин. участников больше макс.']);
        exit;
    }

    // Вставка в БД
    $insertId = $db_connect->insert("co_buyings", [
        "product_id" => $product_id,
        "goal_amount" => $goal_amount,
        "current_amount" => 0,
        "status" => "active",
        "owner_id" => $userId,
        "date_start" => $date_start,
        "date_end" => $date_end,
        "min_participants" => $min_participants,
        "max_participants" => $max_participants
    ]);

    if ($insertId) {
        echo json_encode(['success' => 1, 'co_buying_id' => $insertId]);
    } else {
        echo json_encode(['success' => 0, 'error' => 'Ошибка добавления']);
    }