<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

define('ENGINE_DIR', $_SERVER['DOCUMENT_ROOT'] . '/engine');
require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

session_start();

$text = "";
if (!empty($_POST["uniq_name"])) {
    $session_lang_key = $config['lang_union'] ? 'lang' : 'language';

    $lang_code = isset($_SESSION[$session_lang_key]) ? $_SESSION[$session_lang_key] : $config['default_lang'];

    // Преобразуем язык в нижний регистр
    $lang_code = strtolower($lang_code);

    // Загружаем языковой файл
    $lang = load_language($lang_code);

    $counterWidget = $db_connect->get("counters", "*", ["uniq_name" => $_POST["uniq_name"], "active" => 1]);

    $objectData = [
        "objectCount" => 0,
        "totalCount" => 0
    ];

    if (empty($counterWidget)) {
        $helpName = $db_connect->get("counters", "uniq_name", ["uniq_name[~]" => $_POST["uniq_name"], "active" => 1]);
        if (!empty($helpName)) {
            echo "Ошибка: Счетчик {$_POST["uniq_name"]} не найден, возможно вы хотели ввести $helpName";
        }
    }

    if (!empty($counterWidget) && $counterWidget["active"] === true || !empty($counterWidget) && $counterWidget["active"] == 1) {
        $countObjectParentName = $counterWidget["name"];
        $fromCount = $counterWidget["from_count"];
        $toCount = $counterWidget["to_count"];
        $counterSubObjectType = $counterWidget["counter_sub_object"];

        $modules = [];
        foreach ($config['modules'] as $name => $mConfig) {
            if ($mConfig['used'] === true) {
                $modules[] = $name;
            }
        }

        if ($counterSubObjectType == "views") {
            if ($counterWidget["name"] == "all_modules") {
                foreach ($modules as $module) {
                    $objectData["objectCount"] += $db_connect->sum($module, "views");
                }
            } else {
                $objectData["objectCount"] = $db_connect->sum($counterWidget["name"], "views");
            }
        } elseif ($counterSubObjectType == "comments") {
            if ($counterWidget["name"] == "all_modules") {
                foreach ($modules as $module) {
                    $objectData["objectCount"] += $db_connect->count("comments", ["entity_type" => $module, "status" => 1]);
                }
            } else {
                $objectData["objectCount"] = $db_connect->count("comments", ["entity_type" => $counterWidget["name"], "status" => 1]);
            }
        } elseif ($counterSubObjectType == "user_groups_count") {
            if ($counterWidget["name"] == "all_groups") {
                $objectData["objectCount"] = $db_connect->count("users");
            } else {
                $groupId = $db_connect->get("roles", "id", ["name" => $counterWidget["name"]]);
                $objectData["objectCount"] = $db_connect->count("users", ["group" => $groupId]);
            }

            if ($fromCount == 0 && !empty($toCount)) {
                $objectData["totalCount"] = (int)$toCount - (int)$objectData["objectCount"];
            }

        } elseif ($counterSubObjectType == "all_rows") {
            if ($counterWidget["name"] == "all_modules") {
                foreach ($modules as $module) {
                    $objectData["objectCount"] += $db_connect->count($module);
                }
            } else {
                $objectData["objectCount"] = $db_connect->count($counterWidget["name"]);
            }
        } elseif ($counterSubObjectType == "category_count") {
            if ($counterWidget["name"] == "all_modules") {
                foreach ($modules as $module) {
                    $objectData["objectCount"] += $db_connect->count($module."_categories");
                }
            } else {
                $objectData["objectCount"] = $db_connect->count($counterWidget["name"]."_categories");
            }
        }

        $text = ""; //;
        $moduleName = $lang['module_name'] ?? $lang['topmenu'];
        if ($counterWidget["object_type"] == "modules") {
            if ($counterWidget["name"] != "all_modules") {
                if ($_POST["showTypeName"] == true) {
                    $text .= $lang['datatable'][$counterWidget["counter_sub_object"]]." ({$moduleName[$counterWidget["name"]]}): ". "<b>{$objectData["objectCount"]}</b>";
                } else {
                    $text .= $lang['datatable'][$counterWidget["counter_sub_object"]]." ". "<b>{$objectData["objectCount"]}</b>";
                }
            } else {
                $text .= $lang['datatable'][$counterWidget["counter_sub_object"]]." всех модулей: ". "<b>{$objectData["objectCount"]}</b>";
            }
        } elseif ($counterWidget["object_type"] == "user_groups") {
            if ($counterWidget["name"] != "all_groups") {
                $totalCount = (int)$toCount - (int)$objectData["objectCount"];
                $text .= "Осталось мест в группе ".$counterWidget["name"] .": ". "<b>{$toCount}/{$totalCount}</b>";
            } else {
                if ($_POST["showTypeName"] == true) {
                    $text .= $lang['datatable'][$counterWidget["counter_sub_object"]] . " ({$lang['datatable'][$counterWidget["name"]]}): " . "<b>{$objectData["objectCount"]}</b>";
                } else {
                    $text .= $lang['datatable'][$counterWidget["counter_sub_object"]]." ". "<b>{$objectData["objectCount"]}</b>";
                }
            }
        }

        if (!empty($objectData["totalCount"])) {
            $prefix = !empty($_POST["prefix"]) ? $_POST["prefix"] : "-";
            $residueCount = $counterWidget["counter_type"] == "from" ? $toCount : $fromCount;
            $text = "{$lang["widgets"]["leftpositionsgroup"]} {$counterWidget["name"]}: ".$objectData["totalCount"] ." $prefix $residueCount";
        }

    }

} else {
    $text = "Ошибка: При include() шаблона счетчика укажите uniqName который можете посмотреть в спике счетчиков";
}

echo $text;

function load_language($lang_code) {
    // Путь к основному языковому файлу
    $lang_file = ENGINE_DIR . "/lang/{$lang_code}/website.lng"; // Путь к языковому файлу для админки
    $fields_file = ENGINE_DIR . "/lang/{$lang_code}/fields.lng"; // Путь к языковому файлу для полей

    // Загружаем основной языковой файл
    if (file_exists($lang_file)) {
        $lang = include $lang_file; // Возвращаем массив
    } else {
        // Если язык не найден, используем язык по умолчанию (например, русский)
        $lang = include ENGINE_DIR . "/lang/russian/website.lng"; // Путь к русскому файлу
    }

    // Загружаем файл для полей, если он существует
    if (file_exists($fields_file)) {
        $fields = include $fields_file; // Возвращаем массив полей
        // Объединяем массивы
        $lang = array_merge($lang, $fields);
    } else {
        // Если файл для полей не найден, используем данные по умолчанию
        $fields_default = include ENGINE_DIR . "/lang/russian/fields.lng";
        $lang = array_merge($lang, $fields_default);
    }
    return $lang;
}

