<?php
    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    $id = intval($_GET['id'] ?? -1);
    $lines = file($_SERVER["DOCUMENT_ROOT"] . "/engine/data/cron-jobs.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if ($id >= 0 && isset($lines[$id])) {
        $parts = preg_split('/\s+/', $lines[$id], 6);
        if (count($parts) === 6) {
            echo json_encode([
                'success' => true,
                'min' => $parts[0],
                'hour' => $parts[1],
                'day' => $parts[2],
                'month' => $parts[3],
                'weekday' => $parts[4],
                'command' => $parts[5]
            ]);
            exit;
        }
    }
    echo json_encode(['success' => false]);