<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    global $db_connect;

    session_start();

    $errors = [];

    if(empty($_POST['first_name'])) $errors['first_name'] = "Имя учителя обязателен";
    if(empty($_POST['last_name'])) $errors['last_name'] = "Фамилия учителя обязателен";
    if(empty($_POST['age'])) $errors['age'] = "Возраст ученика обязателен";
    if(empty($_POST['gender'])) $errors['gender'] = "Пол ученика обязателен";

    if($errors){
        echo json_encode(['success'=>false,'errors'=>$errors]);
        exit;
    }

    if (!empty($_POST["email"])) {
        $isExists = $db_connect->has("users", [
            "id[!]" => $_POST['id'],
            "email" => $_POST['email'],
        ]);

        if ($isExists) {
            $errors['email'] = "Ученик с таким email уже существует";
            echo json_encode(['success'=>false,'errors'=>$errors]);
            exit;
        }

    }

    $db_connect->update("users", [
        "name" => $_POST['first_name'] . " " . $_POST['last_name'],
        "email" => $_POST['email'] ?? "",
        "age" => $_POST['age'],
        "gender" => $_POST['gender'],
        "regdate" => date("Y-m-d H:i:s")
    ], [
        "id" => $_POST['id']
    ]);

    echo json_encode(["success" => true]);