<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    define('ENGINE_DIR', $_SERVER['DOCUMENT_ROOT'] . '/engine');
    define('SYSTEM_DIR', $_SERVER['DOCUMENT_ROOT'] . '/system');

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");
    require_once(ENGINE_DIR . '/libs/Smarty.class.php');
    $smarty = new Smarty();

    global $db_connect, $smarty, $lang;

    $smarty->setTemplateDir($_SERVER["DOCUMENT_ROOT"] . '/templates/');
    $smarty->setCompileDir($_SERVER["DOCUMENT_ROOT"] . '/templates_c/');
    session_start();

    if (!empty($_POST["id"])) {

        $studentRoleId = $db_connect->get("roles", "id", ["name" => "Student"]);

        $className = $db_connect->get("classes", "name", ["id" => $_POST["id"]]);

        // Ученики
        $students = $db_connect->select("class_students", [
            "[>]users" => ["student_id" => "id"],
            "[>]users_roles" => ["student_id" => "user_id"]
        ], [
            "users.id",
            "users.name",
            "users.regdate"
        ], [
            "class_students.class_id" => $_POST["id"],
            "users_roles.role_id" => $studentRoleId,
            "users.banned" => 0
        ]);

        $smarty->assign("studentsDataList", $students);

        // Подготовка под datatable
        foreach ($students as &$student) {

            $parentIds = $db_connect->select("parents_students", "parent_id", ["student_id" => $student["id"]]);
            $thisParentsName = [];
            if (!empty($parentIds)) {
                $thisParentsName = $db_connect->select("users", "name", [
                    "id" => $parentIds
                ]);
            }


            $student["parents"] = !empty($thisParentsName)
                ? implode(", ", $thisParentsName)
                : "Родителей нет";

            $student["date"] = $student["regdate"];
            $student["actions"] = "
            <a href='#' class='mx-3 fa fa-edit edit-ico' data-id='{$student['id']}'></a>
            <a href='#' class='mx-3 fa fa-trash delete-ico' data-id='{$student['id']}'></a>
        ";
        }
        unset($student);
        $smarty->registerPlugin('modifier', 'json_encode', function($value) {
            return json_encode($value);
        });
        $smarty->assign("className", $className);
        $smarty->assign('students', $students);
        $html = $smarty->fetch(SYSTEM_DIR."/content/extensions/education/students_list.tpl");

        echo json_encode([
            "success" => true,
            "html" => $html
        ]);
    }