<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

$sourceList = $_POST['selectedData'] ?? '';
$destination = $_SERVER["DOCUMENT_ROOT"]."/".$_POST['destination'] ?? '';

foreach ($sourceList as $sourceAssoc) {
    $source = $_SERVER["DOCUMENT_ROOT"] . "/" . $sourceAssoc["dataPath"];

    if (!file_exists($source)) {
        echo json_encode([
            "status" => false,
            "message" => "Файл или папка \"$source\" не существует."
        ]);
        exit;
    }

    if (is_file($source)) {
        $destination = $destination ."/".$sourceAssoc["dataName"];
        if (copy($source, $destination)) {
            echo json_encode([
                "status" => true,
                "message" => "Файл \"$source\" успешно скопирован в \"$destination\"."
            ]);
            exit();
        } else {
            echo json_encode([
                "status" => false,
                "message" => "Ошибка при копировании файла."
            ]);
            exit();
        }
    } elseif (is_dir($source)) {
        function copyFolder($source, $destination) {
            if (!is_dir($destination)) {
                mkdir($destination, 0755, true);
            }

            $items = scandir($source);
            foreach ($items as $item) {
                if ($item === '.' || $item === '..') {
                    continue;
                }

                $src = $source . DIRECTORY_SEPARATOR . $item;
                $dst = $destination . DIRECTORY_SEPARATOR . $item;

                if (is_dir($src)) {
                    copyFolder($src, $dst);
                } else {
                    copy($src, $dst);
                }
            }
        }

        copyFolder($source, $destination);
        echo json_encode([
            "status" => true,
            "message" => "Папка \"$source\" успешно скопирована в \"$destination\"."
        ]);
        exit();
    } else {
        echo json_encode([
            "status" => false,
            "message" => "Неверный путь."
        ]);
        exit();
    }
}

