<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

$sourceList = $_POST['selectedData'] ?? '';

foreach ($sourceList as $sourceAssoc) {
    $source = $_SERVER["DOCUMENT_ROOT"] . "/" . $sourceAssoc["dataPath"];

    if (!file_exists($source)) {
        echo json_encode(['success' => false, "message" => "Путь $source не найден"], JSON_UNESCAPED_UNICODE);
        exit;
    }

    if (moveToTrash($source)) {
        echo json_encode(['success' => true, "message" => "Обект $source успешно перемещен в корзину"], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode(['success' => false, "message" => "Ошибка прриперемещения обекта"], JSON_UNESCAPED_UNICODE);
    }

}
function moveToTrash($path) {
    if (!file_exists($path)) {
        return false;
    }

    $trashDir = $_SERVER["DOCUMENT_ROOT"] . '/.trash';

    if (!is_dir($trashDir)) {
        if (!mkdir($trashDir, 0777, true)) {
            return false;
        }
    }

    $newPath = $trashDir . DIRECTORY_SEPARATOR . basename($path);

    if (is_dir($path)) {
        $newPath = $trashDir . DIRECTORY_SEPARATOR . basename($path);
        renameDirectoryRecursive($path, $newPath);
    } else {
        if (!rename($path, $newPath)) {
            return false;
        }
    }

    $metadataFile = $trashDir . DIRECTORY_SEPARATOR . basename($path) . '.metadata';
    file_put_contents($metadataFile, json_encode(['original_path' => $path]));

    return true;
}

function renameDirectoryRecursive($sourceDir, $targetDir) {
    if (!is_dir($sourceDir)) {
        return false;
    }

    if (!@mkdir($targetDir, 0777, true)) {
        return false;
    }

    $items = scandir($sourceDir);
    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;

        $sourcePath = $sourceDir . DIRECTORY_SEPARATOR . $item;
        $targetPath = $targetDir . DIRECTORY_SEPARATOR . $item;

        if (is_dir($sourcePath)) {
            renameDirectoryRecursive($sourcePath, $targetPath);
        } else {
            rename($sourcePath, $targetPath);
        }
    }

    return rmdir($sourceDir);
}

