<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");


if (!empty($_POST["name"]) && !empty($_POST["dataName"]) && !empty($_POST["dataPath"])) {
    $fullPath = $_SERVER["DOCUMENT_ROOT"] . "/" . $_POST["dataPath"];
    $extension = pathinfo($fullPath, PATHINFO_EXTENSION);

    $newName = $_POST["name"];
    if (!empty($extension)) {
        $newName .= "." . $extension;
    }

    $newPath = $_SERVER["DOCUMENT_ROOT"] . "/" . $_POST["currentPath"] . "/" . $newName;

    if (rename($fullPath, $newPath)) {
        echo json_encode([
            "status" => true,
            "message" => 'Файл успешно переименован!'
        ]);
    } else {
        echo json_encode([
            "status" => false,
            "message" => 'Ошибка при переименовании файла.'
        ]);
    }
    exit();
}

