<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

$sourceList = $_POST['selectedData'] ?? [];
$destination = $_SERVER["DOCUMENT_ROOT"] . "/" . ($_POST['destination'] ?? '');

if (!is_array($sourceList) || empty($destination)) {
    echo json_encode([
        "status" => false,
        "message" => "Некорректные входные данные."
    ]);
    exit;
}

$results = [];

foreach ($sourceList as $sourceAssoc) {
    $source = $_SERVER["DOCUMENT_ROOT"] . "/" . $sourceAssoc["dataPath"];
    $destinationPath = rtrim($destination, '/') . '/' . basename($source);

    if (!file_exists($source)) {
        $results[] = [
            "status" => false,
            "source" => $source,
            "message" => "Файл или папка \"$source\" не существует."
        ];
        continue;
    }

    $destinationDir = dirname($destinationPath);
    if (!is_dir($destinationDir)) {
        mkdir($destinationDir, 0755, true);
    }

    if (!is_readable($source)) {
        $results[] = [
            "status" => false,
            "source" => $source,
            "message" => "Файл \"$source\" недоступен для чтения."
        ];
        continue;
    }

    if (!is_writable($destinationDir)) {
        $results[] = [
            "status" => false,
            "source" => $source,
            "message" => "Директория \"$destinationDir\" недоступна для записи."
        ];
        continue;
    }

    if (rename($source, $destinationPath)) {
        $results[] = [
            "status" => true,
            "source" => $source,
            "message" => "Файл или папка \"$source\" успешно перемещены в \"$destinationPath\"."
        ];
    } else {
        $error = error_get_last();
        $results[] = [
            "status" => false,
            "source" => $source,
            "message" => "Ошибка при перемещении: " . ($error['message'] ?? "Неизвестная ошибка.")
        ];
    }
}

echo json_encode($results);
