<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

//echo json_encode($_FILES);exit();

if (isset($_FILES['files'])) {
    $files = $_FILES['files'];
    $targetPath = $_POST['targetPath'] == "" ? $_SERVER["DOCUMENT_ROOT"] : $_SERVER["DOCUMENT_ROOT"]."/".$_POST['targetPath'];

    // Проверка на безопасность: убедитесь, что путь безопасен для записи
    // Не используйте входные данные напрямую, проводите дополнительные проверки
    if (realpath($targetPath)) {
        // Получаем абсолютный путь к директории
        //$targetDir = $_SERVER['DOCUMENT_ROOT'] . '/' . $targetPath;

        // Проверяем, существует ли директория
        if (!is_dir($targetPath)) {
            mkdir($targetPath, 0777, true);  // Создаем директорию, если она не существует
        }

        $uploadedFiles = [];
        foreach ($files['name'] as $key => $fileName) {
            $fileTmpName = $files['tmp_name'][$key];
            $targetFile = $targetPath . '/' . basename($fileName);

            // Перемещаем файл в целевую директорию
            if (move_uploaded_file($fileTmpName, $targetFile)) {
                $uploadedFiles[] = $targetFile;
            } else {
                echo json_encode(['error' => 'Не удалось загрузить файл: ' . $fileName]);
                exit;
            }
        }

        // Если все файлы успешно загружены
        if (!empty($uploadedFiles)) {
            echo json_encode(['success' => true, 'files' => $uploadedFiles]);
        }
    } else {
        echo json_encode(['error' => 'Неверный путь для загрузки']);
    }
} else {
    echo json_encode(['error' => 'Файл или путь не переданы']);
}

// Функция для загрузки одиночного файла
function uploadFile($file, $targetDir) {
    $targetFile = $targetDir . basename($file['name']);

    // Проверяем, существует ли файл и его размер
    if ($file['size'] > 0 && move_uploaded_file($file['tmp_name'], $targetFile)) {
        return $targetFile;
    } else {
        return false;
    }
}

// Функция для обработки нескольких файлов
function uploadFiles($files, $targetDir) {
    $uploadedFiles = [];

    foreach ($files['name'] as $key => $name) {
        $file = [
            'name' => $name,
            'type' => $files['type'][$key],
            'tmp_name' => $files['tmp_name'][$key],
            'error' => $files['error'][$key],
            'size' => $files['size'][$key],
        ];

        $uploadedFile = uploadFile($file, $targetDir);

        if ($uploadedFile !== false) {
            $uploadedFiles[] = $uploadedFile;
        }
    }

    return $uploadedFiles;
}

