<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

function addFilesToZip($zip, $dirPath, $baseDir, $sourceAssoc = []) {

    if (is_dir($dirPath)) {
        $files = scandir($dirPath);
    } else {
        $zip->addFile($dirPath, $sourceAssoc["dataName"]);
    }

    if (!empty($files)) {
        foreach ($files as $file) {
            if ($file == '.' || $file == '..') {
                continue;
            }

            $filePath = $dirPath . '/' . $file;
            $relativePath = str_replace($baseDir . '/', '', $filePath);

            if (is_dir($filePath)) {
                addFilesToZip($zip, $filePath, $baseDir, $sourceAssoc);
            } else {
                $zip->addFile($filePath, $sourceAssoc["dataName"]."/".$relativePath);
            }
        }
    }

}

$zip = new ZipArchive();
$zipFileName = 'archive_' . time() . '.zip';
$zipPath = $_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $zipFileName;

if ($zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
    $sourceList = $_POST['selectedData'] ?? '';

    foreach ($sourceList as $sourceAssoc) {
        $source = $_SERVER["DOCUMENT_ROOT"] . "/" . $sourceAssoc["dataPath"];
        addFilesToZip($zip, $source, $source, $sourceAssoc);
    }
    $zip->close();

    echo json_encode([
       "status" => true,
       "filename" => '/uploads/' . $zipFileName,
    ]);
    exit;
} else {
    echo json_encode([
        "status" => false,
        "filename" => "Не удалось создать архив.",
    ]);
    exit();
}

