<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

session_start();

define('ENGINE_DIR', $_SERVER['DOCUMENT_ROOT'] . '/engine');
require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

global $db_connect, $config;

if (!empty($_POST)) {

    $config["cms_installed"] = true;
    $config["title"] = $_POST["siteName"];
    $config["payment_info"]["default_currency"] = $_POST["siteCurrency"];
    $config["default_lang"] = $_POST["siteLanguage"];

    $config["database_settings"]["enabled_database"] = $_POST["dbType"];
    $config["database_settings"][$config["database_settings"]["enabled_database"]]["user"] = $_POST["dbUser"];
    $config["database_settings"][$config["database_settings"]["enabled_database"]]["password"] = $_POST["dbPass"];
    $config["database_settings"][$config["database_settings"]["enabled_database"]]["database"] = $_POST["dbName"];
    $config["database_settings"][$config["database_settings"]["enabled_database"]]["host"] = $_POST["dbHost"];

    foreach ($config["modules"] as &$module) {
        $module["used"] = false;
    }

    foreach ($config["extensions"] as &$extension) {
        $extension["enabled"] = false;
    }


    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/mods/update_config.php");
    require_once($_SERVER["DOCUMENT_ROOT"]. '/install.php');

    if (!empty($_POST["adminPass"]) && !empty($_POST["adminEmail"])) {
        $maxId = $db_connect->max("users", "id");
        $hashPass = password_hash($_POST["adminPass"], PASSWORD_DEFAULT);

        $existsUser = $db_connect->get("users", "email", ["email" => $_POST["adminEmail"]]);
        if (empty($existsUser)) {
            $insertData = [
                "email" => $_POST["adminEmail"],
                "password" => $hashPass,
                "group" => 1,
                "name" => explode("@", $_POST["adminEmail"])[0],
                "age" => 0,
                "gender" => 'Мужчина',
                "phone" => '',
                "city" => '',
                "balance" => 0.00,
                "avatar" => 'uploads/profiles/default.svg',
                "bg_image" => 'uploads/profiles/default-bg.jpg',
                "followers" => 0,
                "likes" => 0,
                "views" => 0,
                "bio" => '',
                "pay_methods" => '',
                "purchases" => 0,
                "sales" => 0,
                "lastdate" => date("Y-m-d H:i:s"),
                "regdate" => date("Y-m-d H:i:s"),
                "banned" => 0,
                "allowpm" => 1,
                "allpm" => 0,
                "pmunread" => 0
            ];
            if ($config["database_settings"]["enabled_database"] == "mysql") {
                $insertData["id"] = $maxId + 1;
            }

            $db_connect->insert("users", $insertData);

            $db_connect->insert("users_roles", [
                "user_id" => $db_connect->id(),
                "role_id" => 2
            ]);
        }
    }

    $updateApi = "https://megadigital.space/engine/api/current_version/check_new_version.php?check";
    $response = file_get_contents($updateApi);
    $data = json_decode($response, true);

    $db_connect->insert("client_version", [
        "version" => $data["version"] == "" ? 0.00001 : $data["version"],
        "client_url" => $_SERVER["HTTP_HOST"],
    ]);

    session_destroy();

    $_COOKIE = [];

    return true;
} else {
    return false;
}