<?php
    /*
                   *****************************************************************************
                   * MEGA Digital Space - by MEGA Digital Studio                               *
                   * ------------------------------------------------------------------------- *
                   * CMS Website:  https://megadigital.space                                   *
                   * License:  https://megadigital.space/license                               *
                   * Owner:  Giorgi Basharuli                                                  *
                   * Contact:  online@megadigital.studio                                       *
                   * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
                   * Website:  https://megadigital.studio                                      *
                   * ------------------------------------------------------------------------- *
                   * Description: This file is a part of the MEGA Digital Space CMS system.    *
                   * Unauthorized distribution, modification, or commercial use is strictly -  *
                   * prohibited without prior written permission.                              *
                   * ------------------------------------------------------------------------- *
                   * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
                   * All rights reserved.                                                      *
                   *****************************************************************************
               */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");
    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/ws_config.php');

    session_start();

    global $db_connect, $config;

    $locations = $db_connect->select('locations', [
        '[>]location_translations' => ['id' => 'location_id']
    ], [
        'locations.id',
        'locations.parent_id',
        'locations.type',
        'locations.slug',
        'location_translations.name',
    ], [
      //  'location_translations.language_code' => $_SESSION['lang'] ?? $config['default_lang'],
    ]);


    $locationsResult = [];

    foreach ($locations as $key => $row) {
        $id = $row['id'];
        if (!isset($locationsResult[$id])) {
            $locationsResult[$id] = $row;
        } else {
            // добавляем имя через запятую
            $locationsResult[$id]['name'] .= ', ' . $row['name'];
        }
    }

    $locationsResult = array_values($locationsResult);

    echo json_encode(['status' => 'success', 'locations' => $locationsResult]);