<?php
    /*
                      *****************************************************************************
                      * MEGA Digital Space - by MEGA Digital Studio                               *
                      * ------------------------------------------------------------------------- *
                      * CMS Website:  https://megadigital.space                                   *
                      * License:  https://megadigital.space/license                               *
                      * Owner:  Giorgi Basharuli                                                  *
                      * Contact:  online@megadigital.studio                                       *
                      * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
                      * Website:  https://megadigital.studio                                      *
                      * ------------------------------------------------------------------------- *
                      * Description: This file is a part of the MEGA Digital Space CMS system.    *
                      * Unauthorized distribution, modification, or commercial use is strictly -  *
                      * prohibited without prior written permission.                              *
                      * ------------------------------------------------------------------------- *
                      * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
                      * All rights reserved.                                                      *
                      *****************************************************************************
                  */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");
    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/ws_config.php');

    session_start();

    global $db_connect, $config;
    $raw = file_get_contents("php://input");
    $locations = json_decode($raw, true);

    $includedLocations = [];
    $excludedLocations = [];
    if (!empty($_GET["page_id"])) {
        $includedLocations = $db_connect->select("access_control", "location_id", [
            "resource_id" => $_GET["page_id"],
            "resource_type" => $_GET["page_type"],
            "list_type" => "include"
        ]);

        $excludedLocations = $db_connect->select("access_control", "location_id", [
            "resource_id" => $_GET["page_id"],
            "resource_type" => $_GET["page_type"],
            "list_type" => "exclude"
        ]);
    }

    echo json_encode([
        'include' => $includedLocations,
        'exclude' => $excludedLocations
    ]);
