<?php
    /*
      *****************************************************************************
      * MEGA Digital Space - by MEGA Digital Studio                               *
      * ------------------------------------------------------------------------- *
      * CMS Website:  https://megadigital.space                                   *
      * License:  https://megadigital.space/license                               *
      * Owner:  Giorgi Basharuli                                                  *
      * Contact:  online@megadigital.studio                                       *
      * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
      * Website:  https://megadigital.studio                                      *
      * ------------------------------------------------------------------------- *
      * Description: This file is a part of the MEGA Digital Space CMS system.    *
      * Unauthorized distribution, modification, or commercial use is strictly -  *
      * prohibited without prior written permission.                              *
      * ------------------------------------------------------------------------- *
      * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
      * All rights reserved.                                                      *
      *****************************************************************************
    */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");
    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/ws_config.php');

    session_start();

    global $db_connect, $config;
    $raw = file_get_contents("php://input");
    $locations = json_decode($raw, true);


    $selectedLocation = $db_connect->get("location_list", "*", [
        "user_id" => $_SESSION["user_id"] ?? 0,
    ]);

    function getRootParent($db, $locationId) {
        $current = $db->get("locations", ["id", "parent_id"], ["id" => $locationId]);

        // пока есть родитель
        while (!empty($current) && !empty($current["parent_id"])) {
            $current = $db->get("locations", ["id", "parent_id"], ["id" => $current["parent_id"]]);
        }

        return $db->get("location_translations", "*", ["location_id" => $current["id"]]); // здесь будет самый верхний родитель
    }

    [$locationName, $locationSlug] = "";
    $locationText = "";
    if (!empty($selectedLocation)) {
        $rootParent = getRootParent($db_connect, $selectedLocation["location_id"]);

        $locationName = $db_connect->get("location_translations", "name", [
            "language_code" => $_SESSION['lang'] ?? $config['default_lang'],
            "location_id" => $selectedLocation['location_id'],
        ]);

        if (empty($locationName)) {
            // fallback
            $locationName = $db_connect->get("location_translations", "name", [
                "language_code" => "english",
                "location_id" => $selectedLocation['location_id'],
            ]);

        }

        $location = $db_connect->get("locations", "*", [
            "id" => $selectedLocation['location_id'],
        ]);

        $locationSlug = $location["slug"] ?? "";

        if ($location["parent_id"] == null || $location["parent_id"] == 0) {
            $locationText = $rootParent["name"];
        } else {
            $locationText = !empty($locationSlug) ?  $rootParent["name"].", ". $locationSlug.", ".$locationName : $rootParent["name"].", ".$locationName;
        }

    } else {
        $locationText = $_SESSION["locationStr"] ?? "";
    }

    echo json_encode([
        's_lang' => $_SESSION['lang'] ?? $config["default_lang"],
        's_currency' => $_SESSION['current_currency'] ?? $config["payment_info"]["default_currency"],
        's_location' => $locationText ?? "",
    ]);