<?php
    /*
                      *****************************************************************************
                      * MEGA Digital Space - by MEGA Digital Studio                               *
                      * ------------------------------------------------------------------------- *
                      * CMS Website:  https://megadigital.space                                   *
                      * License:  https://megadigital.space/license                               *
                      * Owner:  Giorgi Basharuli                                                  *
                      * Contact:  online@megadigital.studio                                       *
                      * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
                      * Website:  https://megadigital.studio                                      *
                      * ------------------------------------------------------------------------- *
                      * Description: This file is a part of the MEGA Digital Space CMS system.    *
                      * Unauthorized distribution, modification, or commercial use is strictly -  *
                      * prohibited without prior written permission.                              *
                      * ------------------------------------------------------------------------- *
                      * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
                      * All rights reserved.                                                      *
                      *****************************************************************************
                  */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");
    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/ws_config.php');

    session_start();

    global $db_connect, $config;
    $raw = file_get_contents("php://input");
    $locations = json_decode($raw, true); // получаем массив PHP

    if (!empty($_POST["locationId"])) {
        $locations = $db_connect->get('locations', [
            '[>]location_translations' => ['id' => 'location_id']
        ], [
            'locations.id',
            'locations.parent_id',
            'locations.type',
            'locations.slug',
            'location_translations.name',
        ], [
            'location_translations.language_code' => $_SESSION['lang'] ?? $config['default_lang'],
            'locations.id' => $_POST["locationId"],

        ]);

        if (!$locations) {
            // fallback на английский
            $locations = $db_connect->get('locations', [
                '[>]location_translations' => ['id' => 'location_id']
            ], [
                'locations.id',
                'locations.parent_id',
                'locations.type',
                'locations.slug',
                'location_translations.name',
            ], [
                'location_translations.language_code' => "english",
                'locations.id' => $_POST["locationId"],
            ]);
        }

        if (!empty($_SESSION["user_id"])) {
            $exists = $db_connect->has("location_list", [
                "user_id" => $_SESSION["user_id"],
            ]);

            if (!$exists) {
                $db_connect->insert('location_list', [
                    'location_id' => $_POST["locationId"],
                    'user_id' => $_SESSION["user_id"],
                    'list_type' => ""
                ]);
            } else {
                $db_connect->update('location_list', [
                    'location_id' => $_POST["locationId"],
                ], [
                    'user_id' => $_SESSION["user_id"],
                ]);
            }
        } else {
            $_SESSION["locationId"] = $_POST['locationId'];
            $_SESSION["locationStr"] = !empty($locations["slug"]) ? $locations["slug"].", ".$locations["name"] : $_POST['name'];
        }

    }

    if (!empty($_POST["currency"])) {
        $_SESSION["current_currency"] = $_POST["currency"];
    }

    if (!empty($_POST["lang"])) {
        $_SESSION["lang"] = $_POST["lang"];
    }

    echo json_encode($locations);