<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    global $db_connect;

    session_start();

    $roleId = (int)($_GET['role_id'] ?? 0);
    $q = trim($_GET['q'] ?? '');

    $where = [];
    if ($roleId !== 0) {
        $where['users_roles.role_id'] = $roleId;
    }
    if ($q !== '') {
        $where['users.name[~]'] = $q;
    }

    $users = $db_connect->select('users', [
        "[>]users_roles" => [
            "id" => "user_id"
        ]
    ] , [
        'users.id',
        'users.name(text)'
    ], $where);

    echo json_encode($users);