<?php
    /*
               *****************************************************************************
               * MEGA Digital Space - by MEGA Digital Studio                               *
               * ------------------------------------------------------------------------- *
               * CMS Website:  https://megadigital.space                                   *
               * License:  https://megadigital.space/license                               *
               * Owner:  Giorgi Basharuli                                                  *
               * Contact:  online@megadigital.studio                                       *
               * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
               * Website:  https://megadigital.studio                                      *
               * ------------------------------------------------------------------------- *
               * Description: This file is a part of the MEGA Digital Space CMS system.    *
               * Unauthorized distribution, modification, or commercial use is strictly -  *
               * prohibited without prior written permission.                              *
               * ------------------------------------------------------------------------- *
               * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
               * All rights reserved.                                                      *
               *****************************************************************************
           */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");
    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/ws_config.php');

    session_start();

    global $db_connect, $ws_config;

    if (!empty($_SESSION['user_id'])) {

        echo json_encode([
            "ws_config" => $ws_config,
            "token" => $db_connect->get("tokens", "token", ["user_id" => $_SESSION['user_id']]) ?? null
        ]);

    } else {

        echo json_encode([
            "ws_config" => $ws_config,
            "token" => null
        ]);

    }
