<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

$stats = [];
if (!empty($_POST['uniq_name'])) {

    $uniqNames = explode(",", $_POST['uniq_name']);

    $widget = $db_connect->select("payment_widgets", "*", ["uniq_name" => $uniqNames]);

    if (!empty($widget)) {
        $widgetIds = [];
        foreach ($widget as $valueAssoc) {
            $settings = json_decode($valueAssoc["settings"], true);
            if ($settings["statistic_counter"]) {
                $widgetIds[] = "dynamic-".$valueAssoc["id"];
            }
        }

        if (!empty($widgetIds)) {
            $stats = getCountryPaymentStats($db_connect, 1, $widgetIds);

            foreach ($stats as $key => &$value) {
                if (empty($value["country"])) {
                    unset($stats[$key]);
                }

                $value["iso"] = "";
                if ($value["country"] != "unknown") {
                    $value["iso"] = getCountryCode($value["country"]);
                }
            }
        }
    }

}

echo json_encode($stats);


function getCountryCode($countryName) {
    $countries = [
        "Armenia" => "AM",
        "Russia" => "RU",
        "United States" => "US",
        "Germany" => "DE",
        "France" => "FR",
        "United Kingdom" => "GB",
        "China" => "CN",
        "India" => "IN",
        "Brazil" => "BR",
        "Canada" => "CA",
        "Japan" => "JP",
        "Austria" => "AT",
        "Ukraine" => "UA",
        "Romania" => "RO"
    ];
    return $countries[$countryName] ?? "";
}

function getCountryPaymentStats($database, $minPayments = 1, $action) {
    return $database->select("transactions", [
        "country",
        "total_payments" => \Medoo\Medoo::raw("COUNT(*)")
    ], [
        "GROUP" => "country",
        "HAVING" => ["total_payments[>=]" => $minPayments],
        "ORDER" => ["total_payments" => "DESC"],
        "action" => $action,
        "status" => "succeeded"
    ]);
}

