<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/
session_start();
define('ENGINE_DIR', $_SERVER['DOCUMENT_ROOT'] . '/engine');
require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

if (!empty($_POST["uniq_name"]) && !empty($_SESSION["user_id"])) {
    $uniq_name = $_POST["uniq_name"];
    $user_id = $_SESSION["user_id"];

    $participationId = $db_connect->get("participations", "id", ["uniq_name" => $uniq_name]) ?? 0;
    $participationGroup = $db_connect->get("participations", "group_id", ["uniq_name" => $uniq_name]) ?? 0;
    $userGroup = $db_connect->get("users", "group", ["id" => $user_id]) ?? 0;
    if ($userGroup != $participationGroup) {
        echo json_encode(3);
        exit();
    }

    if (!empty($participationId)) {
        if (!$db_connect->get("participation_users", "id", ["user_id" => $user_id, "participation_id" => $participationId])) {
            $db_connect->insert("participation_users", [
                "participation_id" => (int)$participationId,
                "user_id" => (int)$user_id,
                "hash" => hash("sha256", $participationId.$user_id),
                "winned" => 0
            ]);

            $user = $db_connect->get("users", "*", ["id" => $user_id]) ?? [];

            //sendEmail($user["email"], "", "Participation created", [], "participation-feedback");
            echo json_encode(true);
        } else {
            echo json_encode(false);
        }
    }

}

