<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

session_start();
define('ENGINE_DIR', $_SERVER['DOCUMENT_ROOT'] . '/engine');
require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

$paymentWidget = [];
if (!empty($_POST["uniq_name"])) {
    $userAuthed = isset($_SESSION['user_id']) || isset($_COOKIE['user_id']) || (isset($_SESSION['user_authenticated']) && $_SESSION['user_authenticated']);
    $paymentWidget = $db_connect->get("payment_widgets", "*", ["uniq_name" => $_POST["uniq_name"]]);

    $paymentWidget["price"] = convertAmount($paymentWidget["price"], $config["payment_info"]["default_currency"], getCurrentCurrency());
    $paymentWidget["is_authed"] = $userAuthed;
    $paymentWidget["settings"] = json_decode($paymentWidget["settings"], true);

    $subscription = $db_connect->get("subscriptions", "*", ["widget_id" => $paymentWidget["id"]]);

    $discountPercent = !empty($config["payment_info"]["default_discount_percent"]) ? $config['payment_info']['default_discount_percent'] : $subscription["discount_percent"] ?? "";
    $discountSum = !empty($config["payment_info"]["default_discount_sum"]) ? $config['payment_info']['default_discount_sum'] : $subscription["discount_sum"] ?? "";

    $paymentWidget["discountedPrice"] = null;
    if (!empty($discountPercent) && $discountPercent > 1) {
        $paymentWidget["discountedPrice"] = round($paymentWidget["price"] - ($paymentWidget["price"] * ($discountPercent / 100)));
    } else if (!empty($discountSum) && $discountSum > 1) {
        $paymentWidget["discountedPrice"] = $paymentWidget["price"] - convertAmount($discountSum, $config["payment_info"]["default_currency"], getCurrentCurrency());
    }

}

function getCurrentCurrency() {
    return isset($_SESSION['current_currency']) ? $_SESSION['current_currency'] : getDefaultCurrency();
}
function getDefaultCurrency() {
    global $config;
    return $config['payment_info']['default_currency'];
}

function convertAmount($amount, $baseCurrency, $currentCurrency)
{
    global $config;

    $currentRate = $config['payment_info']['currencies'][$currentCurrency];
    $baseRate = $config['payment_info']['currencies'][$baseCurrency];
    return convertPrice($amount, $baseCurrency, $currentCurrency, $baseRate, $currentRate);
}

function convertPrice($price, $baseCurrency, $currentCurrency, $baseRate, $currentRate) {
    $price = floatval($price);
    $baseRate = floatval($baseRate);
    $currentRate = floatval($currentRate);
    return round($price * ($currentRate / $baseRate), 2);
}

echo json_encode($paymentWidget);