<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

session_start();

$quizParticipation = [];
if (!empty($_POST["answer_id"]) && !empty($_SESSION["user_id"])) {
    $answer_id = $_POST["answer_id"];
    $user_id = $_SESSION["user_id"];
    $question_id = $_POST["question_id"];

    $answeredQuiz = $db_connect->get("quiz_participations", "*", ["quiz_question_id" => $question_id, "user_id" => $user_id]);

    if (!empty($answeredQuiz)) {
        $db_connect->delete("quiz_participations", ["quiz_question_id" => $question_id, "user_id" => $user_id]);
    }

    $db_connect->insert("quiz_participations", [
        "user_id" => $user_id,
        "quiz_question_id" => $question_id,
        "selected_option" => $answer_id,
        "country" => "Armenia"
    ]);

    $quizParticipation = $db_connect->select("quiz_participations", "*", ["quiz_question_id" => $question_id]);
}

echo json_encode($quizParticipation);