<?php

    /*
           *****************************************************************************
           * MEGA Digital Space - by MEGA Digital Studio                               *
           * ------------------------------------------------------------------------- *
           * CMS Website:  https://megadigital.space                                   *
           * License:  https://megadigital.space/license                               *
           * Owner:  Giorgi Basharuli                                                  *
           * Contact:  online@megadigital.studio                                       *
           * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
           * Website:  https://megadigital.studio                                      *
           * ------------------------------------------------------------------------- *
           * Description: This file is a part of the MEGA Digital Space CMS system.    *
           * Unauthorized distribution, modification, or commercial use is strictly -  *
           * prohibited without prior written permission.                              *
           * ------------------------------------------------------------------------- *
           * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
           * All rights reserved.                                                      *
           *****************************************************************************
       */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    global $db_connect;

    session_start();

    $roleId = intval($_GET['role_id']);
    $column = $_GET['column'];

    $map = [
        "C" => "create",
        "R" => "view",
        "U" => "edit",
        "D" => "delete",
        "P" => "publish",
        "M" => "manage",
        "A" => "add",
        "S" => "settings",
        "G" => "allmodules"
    ];

    $keyword = isset($map[$column]) ? $map[$column] : '';

    $permissions = $db_connect->select("permissions(p)", [
        "[>]role_permissions(rp)" => [
            "p.id" => "permission_id",
            "AND" => [
                "rp.role_id" => $roleId
            ]
        ]
    ], [
        "p.id",
        "p.code",
        "p.description",
        "allow" => \Medoo\Medoo::raw("IF(rp.allow = 1, 1, 0)")
    ], [
        "p.code[~]" => $keyword,
        "ORDER" => ["p.code" => "ASC"]
    ]);

    echo json_encode($permissions);