<?php

    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    global $db_connect;

    session_start();

    $roleId = intval($_POST['role_id']);
    $permId = intval($_POST['permission_id']);
    $allow = intval($_POST['allow']);

    $exists = $db_connect->has("role_permissions", [
        "role_id" => $roleId,
        "permission_id" => $permId
    ]);

    if ($allow == 1 && !$exists) {
        $db_connect->insert("role_permissions", [
            "role_id" => $roleId,
            "permission_id" => $permId,
            "allow" => 1
        ]);
    }

    if ($allow == 0 && $exists) {
        $db_connect->delete("role_permissions", [
            "role_id" => $roleId,
            "permission_id" => $permId
        ]);
    }

    echo json_encode(["ok" => 1]);