<?php
    /*
                   *****************************************************************************
                   * MEGA Digital Space - by MEGA Digital Studio                               *
                   * ------------------------------------------------------------------------- *
                   * CMS Website:  https://megadigital.space                                   *
                   * License:  https://megadigital.space/license                               *
                   * Owner:  Giorgi Basharuli                                                  *
                   * Contact:  online@megadigital.studio                                       *
                   * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
                   * Website:  https://megadigital.studio                                      *
                   * ------------------------------------------------------------------------- *
                   * Description: This file is a part of the MEGA Digital Space CMS system.    *
                   * Unauthorized distribution, modification, or commercial use is strictly -  *
                   * prohibited without prior written permission.                              *
                   * ------------------------------------------------------------------------- *
                   * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
                   * All rights reserved.                                                      *
                   *****************************************************************************
               */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");
    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/ws_config.php');

    session_start();

    global $db_connect, $ws_config;

    header('Content-Type: application/json');


    $data = [
        "shop_id" => (int)$_POST['shop_id'] ?? 0,
        "code" => $_POST['code'] ?? '',
        "description" => $_POST['description'] ?? '',
        "discount_type" => $_POST['discount_type'] ?? 'percent',
        "discount_value" => (int)$_POST['discount_value'] ?? 0,
        "min_order_amount" => (int)$_POST['min_order_amount'] ?? 0,
        "max_uses" => (int)$_POST['max_uses'] ?? 0,
        "start_date" => $_POST['start_date'] ?: null,
        "end_date" => $_POST['end_date'] ?: null,
        "active" => isset($_POST['active']) ? 1 : 0,
    ];
    $data['start_date'] = str_replace('T',' ',$data['start_date']).':00';
    $data['end_date']   = str_replace('T',' ',$data['end_date']).':00';

    // Редактирование или добавление
    if(!empty($_POST['id'])){
        $id = $_POST['id'];
        $db_connect->update('shop_coupons', $data, ['id' => $id]);
        $coupon = $db_connect->get('shop_coupons','*',['id' => $id]);
    } else {
        try {
            $db_connect->insert('shop_coupons', $data);
        }catch (Exception $e) {
          //  $a = 666;
        }
        $id = $db_connect->id();
        $coupon = $db_connect->get('shop_coupons','*',['id' => $id]);
    }

    if($coupon){
        echo json_encode(['success' => true, 'data' => $coupon]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Ошибка сохранения купона']);
    }