<?php

    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    global $db_connect, $currentDatabaseSettings;

    $backupFile = $_SERVER["DOCUMENT_ROOT"] . "/backup.sql";

    $tables = $db_connect->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);

    $backupSQL = "";

    foreach ($tables as $table) {
        // Структура таблицы
        $createTable = $db_connect->query("SHOW CREATE TABLE `$table`")->fetch(PDO::FETCH_ASSOC);
        $backupSQL .= "-- ----------------------------\n";
        $backupSQL .= "-- Table structure for `$table`\n";
        $backupSQL .= "-- ----------------------------\n";
        $backupSQL .= $createTable['Create Table'] . ";\n\n";

        // Данные таблицы
        $rows = $db_connect->select($table, "*");
        if (!empty($rows)) {
            $backupSQL .= "-- ----------------------------\n";
            $backupSQL .= "-- Data for table `$table`\n";
            $backupSQL .= "-- ----------------------------\n";

            foreach ($rows as $row) {
                $values = array_map(function ($val) use ($db_connect) {
                    return $val === null ? "NULL" : $db_connect->pdo->quote($val);
                }, $row);

                $columns = implode(", ", array_map(fn($col) => "`$col`", array_keys($row)));
                $valuesString = implode(", ", $values);

                $backupSQL .= "INSERT INTO `$table` ($columns) VALUES ($valuesString);\n";
            }

            $backupSQL .= "\n";
        }
    }

    file_put_contents($backupFile, $backupSQL);
    echo "✅ Бэкап сохранён в файл: $backupFile\n";