<?php
    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    header('Content-Type: application/json');
    global $db_connect;

    session_start();

    global $db_connect, $user_id, $config;

    $userData = $db_connect->get("users", "*", ["id" => $_SESSION["user_id"]]);

    if (!$userData) {
        return ['success' => false, 'message' => 'Пользователь не найден.'];
    }

    $currentBalance = $userData['balance'];

    $withdrawableAmount = convertAmount($_POST["paySum"], strtoupper($_POST["currency"]), $config["payment_info"]["default_currency"]);

    if ((int)$withdrawableAmount > (int)$currentBalance) {
        echo json_encode(['success' => false, 'message' => 'Недостаточно средств доплаты с баланса.']);
    } else {
        echo json_encode(['success' => true]);
    }

    function convertAmount($amount, $baseCurrency, $currentCurrency)
    {
        global $config;

        $currentRate = $config['payment_info']['currencies'][$currentCurrency];
        $baseRate = $config['payment_info']['currencies'][$baseCurrency];
        return convertPrice($amount, $baseCurrency, $currentCurrency, $baseRate, $currentRate);
    }

    function convertPrice($price, $baseCurrency, $currentCurrency, $baseRate, $currentRate) {
        $price = floatval($price);
        $baseRate = floatval($baseRate);
        $currentRate = floatval($currentRate);
        return round($price * ($currentRate / $baseRate), 2);
    }