<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

if (!empty($_POST["user_id"])) {

    $user_id = $_POST["user_id"];
    unset($_POST["user_id"]);

    if (isset($_FILES['image']) && $_FILES['image']['error'] == UPLOAD_ERR_OK) {
        $dir = 'uploads/profiles/'. date('Y') . '/' . date('m') . '/' . $user_id;
        $uploadDir = $_SERVER['DOCUMENT_ROOT'] . '/' . $dir;

        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $file_count = count(scandir($uploadDir)) - 1;
        $imageName = $file_count . '_' . basename($_FILES['image']['name']);
        $imagePath = $uploadDir . $imageName;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $imagePath)) {
            $image = $dir . $imageName;
        } else {
            $error_message = "Не удалось переместить загруженный файл.";
        }
    } else {
        $image = $_POST['user_avatar'] ?? "";
    }

    if (isset($_FILES['bg_image']) && $_FILES['bg_image']['error'] == UPLOAD_ERR_OK) {
        $dir = 'uploads/profiles/'. date('Y') . '/' . date('m') . '/' . $user_id;
        $uploadDir = $_SERVER['DOCUMENT_ROOT'] . '/' . $dir;

        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $file_count = count(scandir($uploadDir)) - 1;
        $imageName = $file_count . '_' . basename($_FILES['bg_image']['name']);
        $imagePath = $uploadDir . $imageName;

        if (move_uploaded_file($_FILES['bg_image']['tmp_name'], $imagePath)) {
            $bgImage = $dir . $imageName;
        } else {
            $error_message = "Не удалось переместить загруженный файл.";
        }
    } else {
        $bgImage = $_POST['user_bg_image'] ?? "";
    }

    if (empty($imagePath)) {
        $imagePath = "uploads/profiles/default.svg";
    }

    $db_connect->update("users", [
        "name" => $_POST["name"],
        "email" => $_POST["email"] ?? "",
        "phone" => $_POST["phone"],
        "group" => (int)$_POST["group"] ?? 0,
        "gender" => $_POST["gender"],
        "age" => (int)$_POST["age"],
        "city" => $_POST["city"],
     //   "balance" => (int)$_POST["balance"],
        "avatar" => $image,
        "bio" => $_POST["bio"],
        "bg_image" => $imagePath,
       // "banned" => (int)$_POST["banned"],
       // "allowpm" => (int)$_POST["allowpm"],
       // "allpm" => (int)$_POST["allpm"],
      //  "pmunread" => (int)$_POST["pmunread"],
    ], ["id" => $user_id]);

    $_POST["avatar"] = $image;

}


echo json_encode([
    "success" => true,
    "data" => $_POST
]);exit();
