<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

global $config;

$files = getFilesFromDirectory($_SERVER["DOCUMENT_ROOT"] . "/templates/{$config['skin']}/widgets/custom/payments-widgets/{$_POST["selectedObjectType"]}");
echo json_encode($files);
function getFilesFromDirectory(string $directory): array {
    // Проверяем, существует ли папка и является ли она директорией
    if (!is_dir($directory)) {
        throw new InvalidArgumentException("Указанный путь не является директорией: $directory");
    }

    $files = [];

    // Открываем директорию
    $dirHandle = opendir($directory);
    if ($dirHandle === false) {
        throw new RuntimeException("Не удалось открыть директорию: $directory");
    }

    // Перебираем содержимое директории
    while (($file = readdir($dirHandle)) !== false) {
        // Пропускаем текущую и родительскую директории
        if ($file === '.' || $file === '..') {
            continue;
        }

        $filePath = $directory . DIRECTORY_SEPARATOR . $file;

        // Добавляем только файлы с расширением .tpl
        if (is_file($filePath) && pathinfo($file, PATHINFO_EXTENSION) === 'tpl') {
            $fileName = pathinfo($file, PATHINFO_FILENAME);
            $files[] = $fileName;
        }
    }

    // Закрываем директорию
    closedir($dirHandle);

    return $files;
}