<?php
    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once($_SERVER["DOCUMENT_ROOT"] . '/engine/data/config.php');
    require_once($_SERVER["DOCUMENT_ROOT"] . "/engine/data/dbconfig.php");

    header("Access-Control-Allow-Origin: *"); // Разрешаем доступ со всех доменов
    header("Content-Type: application/json");

    global $db_connect;

    $latestVersionAssoc = $db_connect->get("versions", "*", [
        "ORDER" => ["system_version" => "DESC"],
        "is_active" => 1
    ]);

    $latestVersion = $latestVersionAssoc["system_version"] ?? 0; // Актуальная версия CMS
    $zipFile = $latestVersionAssoc["file_path"]; // Файл с обновлением

    if (isset($_GET['check'])) {
        echo json_encode([
            "assoc_version" => $latestVersionAssoc,
            "version" => $latestVersion,
            "update_url" => "https://megadigital.space/$zipFile"
        ]);
        exit;
    }

    if (isset($_GET['download-version'])) {
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="'.$zipFile.'"');
        readfile($_SERVER["DOCUMENT_ROOT"]."/".$zipFile);
        exit;
    }

    echo json_encode(["error" => "Invalid request"]);
