<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Текущая версия CMS
    $currentVersion = '1.0.0';

    // Получаем данные о последней версии с официального сайта
    $versionUrl = 'https://example.com/version.json';
    $versionData = file_get_contents($versionUrl);
    $versionInfo = json_decode($versionData, true);

    // Сравниваем версии
    if (version_compare($currentVersion, $versionInfo['version'], '<')) {
        // Подключаемся к базе данных
        $mysqli = new mysqli('localhost', 'u642471410_se', 'My9hacklife', 'u642471410_se');
        if ($mysqli->connect_error) {
            die('Ошибка подключения (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
        }

        // Получаем всех пользователей
        $result = $mysqli->query("SELECT id FROM users");
        $moduleType = 'CMS';
        $language = 'en';
        $status = 0;
        $details = 'Доступна новая версия CMS: ' . $versionInfo['version'];

        // Добавляем уведомления для всех пользователей
        while ($row = $result->fetch_assoc()) {
            $userId = $row['id'];
            $stmt = $mysqli->prepare("INSERT INTO `notifications` (`user_id`, `module_type`, `language`, `status`, `details`) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param('issis', $userId, $moduleType, $language, $status, $details);
            $stmt->execute();
        }

        // Закрываем соединение
        $stmt->close();
        $mysqli->close();
    }