<?php

    /*
           *****************************************************************************
           * MEGA Digital Space - by MEGA Digital Studio                               *
           * ------------------------------------------------------------------------- *
           * CMS Website:  https://megadigital.space                                   *
           * License:  https://megadigital.space/license                               *
           * Owner:  Giorgi Basharuli                                                  *
           * Contact:  online@megadigital.studio                                       *
           * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
           * Website:  https://megadigital.studio                                      *
           * ------------------------------------------------------------------------- *
           * Description: This file is a part of the MEGA Digital Space CMS system.    *
           * Unauthorized distribution, modification, or commercial use is strictly -  *
           * prohibited without prior written permission.                              *
           * ------------------------------------------------------------------------- *
           * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
           * All rights reserved.                                                      *
           *****************************************************************************
       */

    // Устанавливаем массив для передачи данных в шаблон
    require_once(ENGINE_DIR . '/data/config.php');

    function qrCodeValidationController()
    {
        global $smarty, $config, $db_connect;

        if (!empty($_GET["code"])) {

            try {
                $result = sendQrCodeToApi($_GET["code"]);
                print_r($result);

                if (!empty($result['success']) && !empty($result['token'])) {
                    $smarty->assign('qr_success', true);
                    $smarty->assign('qr_token', $result['token']);
                } else {
                    $smarty->assign('qr_success', false);
                    $smarty->assign('qr_error', $result['error'] ?? 'Неизвестная ошибка');
                }

                $smarty->assign('title', 'Проверка QR Code токена');
                $smarty->assign('page_name', '<li class="breadcrumb-item active">' . "Проверка QR Code токена" . '</li>');
                $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/extensions/qr-token-payload.tpl', []));

                require_once(ENGINE_DIR . '/mods/offline.php');
                exit();
            } catch (Exception $e) {
                echo $e->getMessage();
            }

        }

    }

    function sendQrCodeToApi($code)
    {
        $url = 'http://192.168.110.129/engine/api/qr/validate.php';

        $data = [
            'code' => $code,
            'store_region' => 'NC',       // можно подставить нужный регион
            'api_key' => 'SECRET_API_KEY_FOR_SHOP',
            'order_amount' => 100.0            // пример суммы
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $response = curl_exec($ch);

        if ($response === false) {
            $error = curl_error($ch);
            curl_close($ch);
            throw new Exception("Curl error: $error");
        }

        curl_close($ch);

        return json_decode($response, true);
    }