<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

function PMController() {
    require_once ENGINE_DIR . '/data/ws_config.php';
    require_once ENGINE_DIR . '/mods/language.php';

    global $db_connect, $smarty, $config, $lang;

    if (isset($_GET['pages']) && $_GET["pages"] === "pm") {
        $user = $db_connect->get("users", "*", ["email" => $_SESSION["user_email"] ?? ""]) ?? [];

        if (isset($_GET["uid"])) {
            $usersRelationship = $db_connect->get("user_relationships", "*", ["user_id_from" => $user["id"], "user_id_to" => $_GET["uid"]]) ?? [];

            if (empty($usersRelationship)) {

                $db_connect->insert("user_relationships", [
                    "user_id_from" => $user["id"],
                    "user_id_to" => $_GET["uid"],
                    "can_message" => true
                ]);

                $db_connect->insert("user_relationships", [
                    "user_id_from" => $_GET["uid"],
                    "user_id_to" => $user["id"],
                    "can_message" => true
                ]);

            }
        }


        if (!empty($user)) {
            $token = $db_connect->get("tokens", "*", ["user_id" => $user["id"], "active" => 1, "target" => "chat"]) ?? [];

            if (empty($token)) {
                $tokenStr = bin2hex(random_bytes(16));
                $db_connect->insert("tokens", ["user_id" => $user["id"], "active" => 1, "target" => "chat", "token" => $tokenStr]);

                $token = $db_connect->get("tokens", "*", ["user_id" => $user["id"], "active" => 1, "target" => "chat"]) ?? [];
            }

            $smarty->assign('langJson', json_encode($lang["chat"]));
            $smarty->assign('status', $user["status"]);
            $smarty->assign('token', $token["token"]);
            $smarty->assign('title', 'Личные сообщения');
            $smarty->assign('wsConfig', $ws_config);
            $smarty->assign('page_name', '<li class="breadcrumb-item active">' . "Personal messages" . '</li>');
            $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/chat/personal-messages.tpl', ['user' => $user]));
        } else {
            $smarty->assign('error_message', 'У вас нету доступа к этому чату');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
        }

        require_once(ENGINE_DIR . '/mods/offline.php');
        exit();
    }

}