<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    function ticketsChatController() {
        require_once ENGINE_DIR . '/data/ws_config.php';
        require_once ENGINE_DIR . '/mods/language.php';

        global $db_connect, $smarty, $config, $lang;

        if (isset($_GET['pages']) && $_GET["pages"] === "myTickets") {
            $user = $db_connect->get("users", "*", ["email" => $_SESSION["user_email"] ?? ""]) ?? [];

            if (empty($user)) {
                $smarty->assign('error_message', 'Авторизуйтесь для просмотра ваших тикетов');
                $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
                exit();
            }

            $token = $db_connect->get("tokens", "*", ["user_id" => $user["id"], "active" => 1, "target" => "chat"]) ?? [];

            if (empty($token)) {
                $tokenStr = bin2hex(random_bytes(16));
                $db_connect->insert("tokens", ["user_id" => $user["id"], "active" => 1, "target" => "chat", "token" => $tokenStr]);

                $token = $db_connect->get("tokens", "*", ["user_id" => $user["id"], "active" => 1, "target" => "chat"]) ?? [];
            }

            $smarty->registerPlugin('modifier', 'json_encode', 'json_encode');
            $smarty->assign('status', $user["status"]);
            $smarty->assign('token', $token["token"]);
            $smarty->assign('wsConfig', $ws_config);
            $smarty->assign('langJson', json_encode($lang["chat"]));
            $smarty->assign('title', 'My tickets');
            $smarty->assign('page_name', '<li class="breadcrumb-item active">' . "My tickets" . '</li>');
            $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/chat/tickets-chat.tpl', ['user' => $user]));

            require_once(ENGINE_DIR . '/mods/offline.php');
            exit();

        }

    }