<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

	// Устанавливаем массив для передачи данных в шаблон
	require_once(ENGINE_DIR . '/data/config.php');
    require_once(ENGINE_DIR . '/mods/smarty_temp_tpl.php');

    function homeController() {
        global $db_connect, $smarty, $config, $lang_code, $lang;
    
        if ($config['home_tpl'] === false) {
            // Если главная страница - это 'home', получаем её содержимое из базы данных
            $pageContent = $db_connect->get("static_pages", "*", [
                "alt_name" => "home",
                "language" => $lang_code
            ]);
    
            if (!$pageContent) {
                // Если страница не найдена
                $smarty->assign('error_message', 'Страница \'main\' не найдена!');
                $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
            } else {
                // Декодируем полный текст страницы
                $pageContent['full_desc'] = html_entity_decode($pageContent['full_desc'], ENT_QUOTES, 'UTF-8');

                $pageContent['full_desc'] = renderTempTpl($smarty, $pageContent['full_desc']);

                $smarty->assign("currency", getCurrentCurrency());

                $staticPage = $db_connect->get("static_pages", "*", ["alt_name" => "home", "language" => $lang_code]);

                $moduleName = $staticPage["alt_name"];
                $moduletype["id"] = $staticPage["id"];
                require_once(ENGINE_DIR . '/mods/widget-select.php');

                if (!empty($widget)) {
                    $smarty->assign('dynamicName', "pages");
                    $smarty->assign('price', $widget["price"]);
                    $smarty->assign('widgetId', $widget["id"]);

                    $html = $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/payments-widgets/' . $widget["template_name"] . ".tpl");
                    $pageContent['full_desc'] = preg_replace('/\{\s*payment-widget\s*\}/', $html, $pageContent['full_desc']);
                } else {
                    $pageContent['full_desc'] = preg_replace('/\{\s*payment-widget\s*\}/', "", $pageContent['full_desc']);
                }

                // Устанавливаем массив переменных в Smarty
                $smarty->assign('title', $pageContent['title'] . ' - ' . $config['title']);
                $smarty->assign('page_name', '
                    <li class="breadcrumb-item active">' . $pageContent['title'] . '</li>
                ');
                // Передаем данные в Smarty
                $smarty->assign('content', $pageContent['full_desc']);
            }
    
        } else {
            // Передаем шаблон главной страницы
            $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/home.tpl'));
        }
    
        // Устанавливаем переменные для Smarty
        $homepage = $lang['general']['homepage'];
        $smarty->assign('title', $lang['general']['homepage'] . ' - ' . $config['title']);
        $smarty->assign('homepage', $homepage);
        $smarty->assign('page_name', '<li class="breadcrumb-item active">'. $lang['general']['homepage'] . '</li>');
    
        // Проверяем, выключен ли сайт
        require_once(ENGINE_DIR . '/mods/offline.php');
    }
    
    $smarty->assign($config);