<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    $sqlPopularLots = "SELECT * FROM lots WHERE language = ? ORDER BY rating DESC LIMIT 10";
    $stmt = $db_connect->prepare($sqlPopularLots);
    $stmt->bind_param('s', $lang_code);
    $stmt->execute();
    $resultPopularLots = $stmt->get_result();
    if ($resultPopularLots === false) {
        die("Ошибка выполнения запроса: " . $db_connect->error);
    }
    $popularLots = $resultPopularLots->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    // Преобразование HTML-сущностей в обычные символы
    foreach ($latestLots as &$event) {
        foreach ($event as $key => $value) {
            $event[$key] = html_entity_decode($value, ENT_QUOTES | ENT_HTML5, 'UTF-8');
        }
    }
    
    // Передаем данные в Smarty
    $smarty->assign('popularLots', $popularLots);