<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Устанавливаем массив для передачи данных в шаблон
    require_once(ENGINE_DIR . '/data/config.php');

    function auctionsByCategoryController($category, $lang_code) {
        global $db_connect, $smarty, $config, $lang;
        $categoryData = $db_connect->get("auctions_categories", "*", ["alt_name" => $category]);

        if (!$categoryData) {
            // Категория не найдена, отображаем ошибку 404
            header("HTTP/1.0 404 Not Found");
            $smarty->assign('error_message', 'Категория не найдена');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
            exit;
        }

        $categorySearch = '%' . $categoryData['name'] . '%';

        require_once ENGINE_DIR . '/mods/module_condition_data.php';
        $auctionsList = getFilterDataList("auctions", $lang_code, null, [
            "n.start_price", "n.current_price", "n.buy_now_price", "n.start_date",
            "n.end_date", "n.created_at", "n.participants", "n.capacity"
        ], $categoryData["id"]);
        require_once ENGINE_DIR . '/mods/get_module_categories.php';

        $currentCurrency = getCurrentCurrency();
        $baseCurrency = $config['payment_info']['default_currency'];
        $baseRate = $config['payment_info']['currencies'][$baseCurrency];
        $currentRate = $config['payment_info']['currencies'][$currentCurrency];

        foreach ($auctionsList as &$auctions) {
            $auctions['converted_price'] = convertPrice($auctions['start_price'], $baseCurrency, $currentCurrency, $baseRate, $currentRate);


            $auctions['category_alt_names'] = getCategoriesAltNames($auctions['id'], "auctions");
            $categories = getCategoriesList($auctions['id'], "auctions");
    
            if (!empty($auctions['short_desc'])) {
                $auctions['short_desc'] = html_entity_decode($auctions['short_desc'], ENT_QUOTES, 'UTF-8');
            }
        }
        $categoriesDataList = getModuleCategoriesDataList("auctions");

        $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
        $auctionsPerPage = $config['modules']['auctions']['auctions_fromcats_per_page'];

        require_once(ENGINE_DIR . '/mods/pagination.php');
        $totalPages = ceil(count($auctionsList) / $auctionsPerPage);
    
        // Определяем, с какой новости начинать отображение на текущей странице
        $start = ($currentPage - 1) * $auctionsPerPage;
    
        // Передаем данные в Smarty
        $smarty->assign('categoriesDataList', $categoriesDataList);
        $smarty->assign('title', $lang['module_name']['auctions'] . ' - ' . $config['title']);
        $smarty->assign('page_name', '
            <li class="breadcrumb-item"><a href="/auctions">' . $lang['module_name']['auctions'] . '</a></li>
            <li class="breadcrumb-item active">' . $categoryData['name'] . '</li>
        ');
        $smarty->assign('currentPage', $currentPage);
        $smarty->assign('totalPages', $totalPages);
        $smarty->assign('pagination', generatePagination($currentPage, $totalPages));
        $smarty->assign('currentCurrency', $currentCurrency);
        $smarty->assign('auctionsList', array_slice($auctionsList, $start, $auctionsPerPage));
        $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/auctions/' . $config['modules']['auctions']['short_tpl'], ['auctionsList' => array_slice($auctionsList, $start, $auctionsPerPage), 'category_alt_names' => $categoryData['alt_name']]));
    
        // Проверяем, выключен ли сайт
        require_once(ENGINE_DIR . '/mods/offline.php');
    }
    
    $smarty->assign($config);    