<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/dbconfig.php');
/*
	// Удаление таблиц перед повторным созданием
	if ($db_connect->query("SHOW TABLES LIKE 'lots'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `lots`');
	}
	if ($db_connect->query("SHOW TABLES LIKE 'lots_categories'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `lots_categories`');
	}*/

	// Флаг для отслеживания успешности выполнения запросов
    $successFlag = true;
    $enabledDatabase = $config["database_settings"]["enabled_database"];
    $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];
// Массив с запросами на создание таблиц
    $createTablesPG = [
        'CREATE TABLE IF NOT EXISTS "lots" (
                "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор аукциона
                "author" VARCHAR(40), -- Автор, создавший аукцион
                "created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания записи аукциона
                "language" VARCHAR(190), -- Язык мероприятия
                "title" VARCHAR(255) NOT NULL, -- Название аукциона
                "alt_name" VARCHAR(190), -- Альтернативное имя (URL)
                "image" VARCHAR(255), -- Ссылка на изображение товара
                "short_desc" TEXT, -- Краткое описание мероприятия
                "full_desc" TEXT, -- Полное описание мероприятия
                "start_price" DECIMAL(10, 2) NOT NULL, -- Начальная цена
                "current_price" DECIMAL(10, 2), -- Текущая цена
                "buy_now_price" DECIMAL(10, 2), -- Цена "Купить сейчас"
                "start_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время начала аукциона
                "end_date" TIMESTAMP, -- Дата и время окончания аукциона
                "participants" INT, -- Количество подписанных участников
                "capacity" INT, -- Максимальное количество участников
                "status" VARCHAR(50), -- Статус аукциона (active, completed, canceled)
                "winner" VARCHAR(40), -- Победитель аукциона
                "bids_count" INT DEFAULT 0, -- Количество ставок
                "views" INT DEFAULT 0, -- Количество просмотров
                "tags" VARCHAR(255), -- Теги (разделенные запятыми)
                "meta_desc" VARCHAR(300), -- Мета-описание для SEO
                "meta_keys" TEXT -- Мета-ключевые слова для SEO
            )',

        'CREATE TABLE IF NOT EXISTS "lots_fields" (
                "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор
                "x_name" VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
                "column_type" VARCHAR(255) NOT NULL, -- Тип столбца в таблице
                "column_length" INT DEFAULT 0 -- Длина
            )',

        'CREATE TABLE IF NOT EXISTS "lots_field_values" (
                "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор
                "lots_id" INT NOT NULL, -- ID новости
                "field_id" INT NOT NULL, -- ID поля из lots_fields
                "x_value" TEXT NOT NULL, -- Значение поля (универсальное хранилище)
                FOREIGN KEY ("lots_id") REFERENCES "lots"("id") ON DELETE CASCADE,
                FOREIGN KEY ("field_id") REFERENCES "lots_fields"("id") ON DELETE CASCADE
            )',

        'CREATE TABLE IF NOT EXISTS "lots_categories" (
                "id" SERIAL PRIMARY KEY,
                "parentid" INT, -- Родительская категория
                "position" INT, -- Позиция
                "language" VARCHAR(190), -- Язык
                "name" VARCHAR(50), -- Название категории
                "alt_name" VARCHAR(50), -- Альтернативное имя (URL)
                "meta_desc" VARCHAR(300), -- Мета-описание для SEO
                "meta_keys" TEXT, -- Мета-ключевые слова для SEO
                "short_tpl" VARCHAR(40), -- Шаблон для краткого описания
                "full_tpl" VARCHAR(40), -- Шаблон для полного описания
                "comments" BOOLEAN, -- Наличие комментариев
                "views" INT DEFAULT 0 -- Количество просмотров
            )',

        'CREATE TABLE IF NOT EXISTS "lots_participants" (
                "id" SERIAL PRIMARY KEY, -- Уникальный идентификатор записи
                "lots_title" VARCHAR(255), -- Название лота
                "user_id" INT NOT NULL, -- ID пользователя
                "username" VARCHAR(255), -- Имя пользователя
                "phone" VARCHAR(20), -- Телефон пользователя
                "social_url" VARCHAR(255), -- Сссылка на страницу в соц. сети
                "registration_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата подписки
                "status" VARCHAR(50), -- Статус подписки
                "ip" VARCHAR(45), -- IP-адрес пользователя
                "city" VARCHAR(255), -- Город пользователя
                "notes" TEXT -- Дополнительные заметки
            )',

        'CREATE TABLE IF NOT EXISTS lots_cat_relations (
            lots_id INT NOT NULL,
            category_id INT NOT NULL,
            PRIMARY KEY (lots_id, category_id),
            CONSTRAINT fk_lots
                FOREIGN KEY (lots_id) REFERENCES lots(id)
                ON DELETE CASCADE
                ON UPDATE CASCADE,
            CONSTRAINT fkl_category
                FOREIGN KEY (category_id) REFERENCES lots_categories(id)
                ON DELETE CASCADE
                ON UPDATE CASCADE
        );'
    ];

    $createTablesMySQL = [
        'CREATE TABLE IF NOT EXISTS auctions (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
            user_id INT UNSIGNED NOT NULL,
            title VARCHAR(255) NOT NULL,
            `short_desc` MEDIUMTEXT DEFAULT NULL,
            `full_desc` MEDIUMTEXT DEFAULT NULL,
            start_price DECIMAL(12,2) NOT NULL DEFAULT 0.00,
            current_price DECIMAL(12,2) NOT NULL DEFAULT 0.00,
            buy_now_price DECIMAL(12,2) DEFAULT NULL,
            `language` VARCHAR(190) DEFAULT NULL, 
            `views` INT DEFAULT 0,
            `meta_desc` VARCHAR(300) DEFAULT NULL,
            `meta_keys` TEXT DEFAULT NULL,
            -- статус: 0=draft, 1=active, 2=finished, 3=cancelled
            status TINYINT UNSIGNED NOT NULL DEFAULT 0,
            
            start_at DATETIME NULL,
            end_at DATETIME NULL,
        
            winner_id INT UNSIGNED DEFAULT NULL,
            finished_price DECIMAL(12,2) DEFAULT NULL,
        
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        
            INDEX (user_id),
            INDEX (status),
            INDEX (start_at),
            INDEX (end_at),
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',

        'CREATE TABLE IF NOT EXISTS `auctions_fields` (
                `id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
                `x_name` VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
                `column_type` VARCHAR(255) NOT NULL, -- Тип столбца в таблице
                `column_length` INT DEFAULT 0, -- Длина
                PRIMARY KEY (`id`)
            ) ENGINE=INNODB DEFAULT CHARSET=utf8',

        'CREATE TABLE IF NOT EXISTS `auctions_field_values` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`auctions_id` INT(11) NOT NULL, -- ID новости
			`field_id` INT(11) NOT NULL, -- ID поля из ads_fields
			`x_value` TEXT NOT NULL, -- Значение поля (универсальное хранилище)
			PRIMARY KEY (`id`),
			FOREIGN KEY (`auctions_id`) REFERENCES `auctions`(`id`) ON DELETE CASCADE,
			FOREIGN KEY (`field_id`) REFERENCES `auctions_fields`(`id`) ON DELETE CASCADE
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

        'CREATE TABLE IF NOT EXISTS `auctions_categories` (
                `id` INT(11) NOT NULL AUTO_INCREMENT,
                `parentid` INT(11) DEFAULT NULL,
                `position` INT(11) DEFAULT NULL,
                `language` VARCHAR(190) DEFAULT NULL,
                `name` VARCHAR(50) DEFAULT NULL,
                `alt_name` VARCHAR(50) DEFAULT NULL,
                `meta_desc` VARCHAR(300) DEFAULT NULL,
                `meta_keys` TEXT DEFAULT NULL,
                `short_tpl` VARCHAR(40) DEFAULT NULL,
                `full_tpl` VARCHAR(40) DEFAULT NULL,
                `comments` TINYINT(1) DEFAULT NULL,
                `views` INT DEFAULT 0,
                PRIMARY KEY (`id`)
            ) ENGINE=INNODB DEFAULT CHARSET=utf8',

        'CREATE TABLE IF NOT EXISTS `auctions_participants` (
                `id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор записи
                `auctions_title` VARCHAR(255) DEFAULT NULL, -- ID аукциона, на которое подписан участник
                `user_id` INT(11) NOT NULL, -- ID пользователя, подписанного на аукцион
                `username` VARCHAR(255) DEFAULT NULL, -- Имя пользователя
                `phone` VARCHAR(20) DEFAULT NULL, -- Телефон пользователя
                `social_url` VARCHAR(255) DEFAULT NULL, -- Сссылка на страницу в соц сети
                `registration_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время подписки на аукцион
                `status` VARCHAR(50) DEFAULT NULL, -- Статус подписки (например: pending, confirmed, cancelled)
                `ip` VARCHAR(45) DEFAULT NULL, -- IP-адрес пользователя
                `city` VARCHAR(255) DEFAULT NULL, -- Город пользователя
                `notes` TEXT DEFAULT NULL, -- Дополнительные заметки о подписке
                PRIMARY KEY (`id`) -- Основной ключ
            ) ENGINE=INNODB DEFAULT CHARSET=utf8',

        'CREATE TABLE IF NOT EXISTS `auctions_cat_relations` (
            `auctions_id` INT NOT NULL,
            `category_id` INT NOT NULL,
            PRIMARY KEY (`auctions_id`, `category_id`),
            CONSTRAINT `fk_auctions`
                FOREIGN KEY (`auctions_id`) REFERENCES `auctions`(`id`)
                ON DELETE CASCADE
                ON UPDATE CASCADE,
            CONSTRAINT `fkauctions_category`
                FOREIGN KEY (`category_id`) REFERENCES `auctions_categories`(`id`)
                ON DELETE CASCADE
                ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',


        'CREATE TABLE IF NOT EXISTS auction_bids (  -- 2. Ставки
            id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            auction_id INT UNSIGNED NOT NULL,
            user_id INT UNSIGNED NOT NULL,
            amount DECIMAL(12,2) NOT NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            INDEX (auction_id),
            INDEX (user_id),
            INDEX (amount)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',

        'CREATE TABLE IF NOT EXISTS auction_images (
            id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            auction_id INT UNSIGNED NOT NULL,
            img_path VARCHAR(255) NOT NULL,
            sort_order INT UNSIGNED NOT NULL DEFAULT 0,
            INDEX (auction_id),
            INDEX (sort_order)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;'
    ];

    $createTables = [];
    if ($enabledDatabase == "mysql") {
        $createTables = $createTablesMySQL;
    } elseif ($enabledDatabase == "pgsql") {
        $createTables = $createTablesPG;
    }

    // Выполняем запросы на создание таблиц
    foreach ($createTables as $sql) {
        if ($db_connect->query($sql) !== TRUE) {
            echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
            $successFlag = false;
        }
    }

    // --- Категории ---
    $categories = [
        ['name' => 'Автомобили', 'language' => 'ru'],
        ['name' => 'Картины', 'language' => 'ru'],
        ['name' => 'Электроника', 'language' => 'ru']
    ];

    $categoryIds = [];
    foreach ($categories as $cat) {
        $db_connect->insert('auctions_categories', $cat);
        $categoryIds[] = $db_connect->id();
    }

    // --- Аукционы ---
    $now = date('Y-m-d H:i:s');
    $endTimes = [
        date('Y-m-d H:i:s', strtotime('+3 days')),
        date('Y-m-d H:i:s', strtotime('+5 days')),
        date('Y-m-d H:i:s', strtotime('+7 days'))
    ];

    $auctions = [
        [
            'user_id' => 1,
            'title' => 'Редкий коллекционный автомобиль',
            'short_desc' => 'В идеальном состоянии, ограниченный выпуск.',
            'full_desc' => 'Полное описание автомобиля: двигатель V8, пробег 20 000 км, полный пакет документов.',
            'start_price' => 50000.00,
            'current_price' => 50000.00,
            'buy_now_price' => 80000.00,
            'language' => 'russian',
            'status' => 1,
            'start_at' => $now,
            'end_at' => $endTimes[0]
        ],
        [
            'user_id' => 2,
            'title' => 'Антикварная картина XIX века',
            'short_desc' => 'Шедевр известного художника.',
            'full_desc' => 'Картина в отличном состоянии, проверена экспертами, уникальная возможность для коллекционеров.',
            'start_price' => 2000.00,
            'current_price' => 2000.00,
            'buy_now_price' => 5000.00,
            'language' => 'russian',
            'status' => 1,
            'start_at' => $now,
            'end_at' => $endTimes[1]
        ],
        [
            'user_id' => 3,
            'title' => 'Игровая консоль последнего поколения',
            'short_desc' => 'Новая, с гарантией.',
            'full_desc' => 'Консоль в полной комплектации, включает 2 контроллера и популярные игры, гарантия 12 месяцев.',
            'start_price' => 300.00,
            'current_price' => 300.00,
            'buy_now_price' => 500.00,
            'language' => 'russian',
            'status' => 1,
            'start_at' => $now,
            'end_at' => $endTimes[2]
        ]
    ];

    $auctionIds = [];
    foreach ($auctions as $auction) {
        $db_connect->insert('auctions', $auction);
        $auctionIds[] = $db_connect->id();
    }

    // --- Связь аукционов с категориями ---
    $relations = [
        ['auction_id' => $auctionIds[0], 'category_id' => $categoryIds[0]], // Автомобиль
        ['auction_id' => $auctionIds[1], 'category_id' => $categoryIds[1]], // Картина
        ['auction_id' => $auctionIds[2], 'category_id' => $categoryIds[2]]  // Электроника
    ];

    foreach ($relations as $rel) {
        $db_connect->insert('auctions_cat_relations', [
            'auctions_id' => $rel['auction_id'],
            'category_id' => $rel['category_id']
        ]);
    }

    // --- Участники ---
    $participants = [
        ['auctions_title' => 'Редкий коллекционный автомобиль', 'user_id' => 101, 'username' => 'Ivan', 'phone' => '+79991234567', 'status' => 'confirmed'],
        ['auctions_title' => 'Антикварная картина XIX века', 'user_id' => 102, 'username' => 'Olga', 'phone' => '+79997654321', 'status' => 'pending'],
        ['auctions_title' => 'Игровая консоль последнего поколения', 'user_id' => 103, 'username' => 'Alex', 'phone' => '+79993456789', 'status' => 'confirmed']
    ];

    foreach ($participants as $p) {
        $db_connect->insert('auctions_participants', $p);
    }

    // --- Изображения ---
    $images = [
        ['auction_id' => $auctionIds[0], 'img_path' => '/uploads/images/auctions/car.jpg', 'sort_order' => 1],
        ['auction_id' => $auctionIds[1], 'img_path' => '/uploads/images/auctions/image_anti.jpg', 'sort_order' => 1],
        ['auction_id' => $auctionIds[2], 'img_path' => '/uploads/images/auctions/console.jpg', 'sort_order' => 1]
    ];

    foreach ($images as $img) {
        $db_connect->insert('auction_images', $img);
    }



	// Проверяем флаг и выводим сообщение
	if ($successFlag) {
		echo "
			<script>
				alert('Данные модуля новостей успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
		exit();
	}