<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

	// Удаление таблиц перед повторным созданием
	if ($db_connect->query("SHOW TABLES LIKE 'ads'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `ads`');
	}
	if ($db_connect->query("SHOW TABLES LIKE 'ads_categories'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `ads_categories`');
	}

	// Флаг для отслеживания успешности выполнения запросов
	$successFlag = true;

	// Массив с запросами на создание таблиц
    $createTables = [
        // Таблица audio_tracks
        'CREATE TABLE IF NOT EXISTS `audio_tracks` (
            `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT "Уникальный идентификатор трека",
            `title` VARCHAR(255) NOT NULL COMMENT "Название трека",
            `artist_id` INT(11) NOT NULL COMMENT "Ссылка на исполнителя (audio_artists.id)",
            `album_id` INT(11) DEFAULT NULL COMMENT "Ссылка на альбом (audio_albums.id), если трек относится к альбому",
            `genre_id` INT(11) DEFAULT NULL COMMENT "Ссылка на жанр (audio_genres.id)",
            `duration` INT(11) NOT NULL COMMENT "Длительность трека в секундах",
            `release_date` DATE DEFAULT NULL COMMENT "Дата выпуска трека",
            `file_id` INT(11) DEFAULT NULL COMMENT "Ссылка на файл трека (audio_files.id)",
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT "Время создания записи",
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT "Время последнего обновления записи",
            PRIMARY KEY (`id`)
        ) ENGINE=INNODB DEFAULT CHARSET=utf8',
    
        // Таблица audio_artists
        'CREATE TABLE IF NOT EXISTS `audio_artists` (
            `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT "Уникальный идентификатор исполнителя",
            `name` VARCHAR(255) NOT NULL COMMENT "Имя исполнителя или группы",
            `bio` TEXT DEFAULT NULL COMMENT "Описание или биография исполнителя",
            `photo_id` INT(11) DEFAULT NULL COMMENT "Ссылка на фото исполнителя (audio_files.id)",
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT "Время создания записи",
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT "Время последнего обновления записи",
            PRIMARY KEY (`id`)
        ) ENGINE=INNODB DEFAULT CHARSET=utf8',
    
        // Таблица audio_albums
        'CREATE TABLE IF NOT EXISTS `audio_albums` (
            `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT "Уникальный идентификатор альбома",
            `title` VARCHAR(255) NOT NULL COMMENT "Название альбома",
            `artist_id` INT(11) NOT NULL COMMENT "Ссылка на исполнителя (audio_artists.id)",
            `release_date` DATE DEFAULT NULL COMMENT "Дата выпуска альбома",
            `cover_id` INT(11) DEFAULT NULL COMMENT "Ссылка на изображение обложки (audio_files.id)",
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT "Время создания записи",
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT "Время последнего обновления записи",
            PRIMARY KEY (`id`)
        ) ENGINE=INNODB DEFAULT CHARSET=utf8',
    
        // Таблица audio_genres
        'CREATE TABLE IF NOT EXISTS `audio_genres` (
            `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT "Уникальный идентификатор жанра",
            `name` VARCHAR(255) NOT NULL COMMENT "Название жанра",
            `description` TEXT DEFAULT NULL COMMENT "Описание жанра (опционально)",
            PRIMARY KEY (`id`)
        ) ENGINE=INNODB DEFAULT CHARSET=utf8',
    
        // Таблица audio_playlists
        'CREATE TABLE IF NOT EXISTS `audio_playlists` (
            `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT "Уникальный идентификатор плейлиста",
            `title` VARCHAR(255) NOT NULL COMMENT "Название плейлиста",
            `user_id` INT(11) DEFAULT NULL COMMENT "Ссылка на пользователя (users.id), если плейлист создаётся пользователем",
            `description` TEXT DEFAULT NULL COMMENT "Описание плейлиста",
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT "Время создания записи",
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT "Время последнего обновления записи",
            PRIMARY KEY (`id`)
        ) ENGINE=INNODB DEFAULT CHARSET=utf8',
    
        // Таблица audio_playlist_tracks
        'CREATE TABLE IF NOT EXISTS `audio_playlist_tracks` (
            `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT "Уникальный идентификатор записи",
            `playlist_id` INT(11) NOT NULL COMMENT "Ссылка на плейлист (audio_playlists.id)",
            `track_id` INT(11) NOT NULL COMMENT "Ссылка на трек (audio_tracks.id)",
            `track_order` INT(11) DEFAULT NULL COMMENT "Порядок трека в плейлисте (опционально)",
            PRIMARY KEY (`id`)
        ) ENGINE=INNODB DEFAULT CHARSET=utf8',
    
        // Таблица audio_files
        'CREATE TABLE IF NOT EXISTS `audio_files` (
            `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT "Уникальный идентификатор файла",
            `path` VARCHAR(255) NOT NULL COMMENT "Путь к файлу",
            `type` VARCHAR(50) NOT NULL COMMENT "Тип файла (например, audio/mp3)",
            `size` INT(11) NOT NULL COMMENT "Размер файла в байтах",
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT "Время создания записи",
            PRIMARY KEY (`id`)
        ) ENGINE=INNODB DEFAULT CHARSET=utf8'
    ];
    
    // Выполняем запросы на создание таблиц
    foreach ($createTables as $sql) {
        if ($db_connect->query($sql) !== TRUE) {
            echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
            $successFlag = false;
        }
    }

	// Массив с запросами на добавление данных в таблицы
	$addData = [
		// Добавление данных в таблицу `audio_tracks`
		"INSERT INTO `audio_tracks` (`id`) VALUES (1)",
	];

	// Выполнение запросов
	foreach ($addData as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}

	// Проверяем флаг и выводим сообщение
	if ($successFlag) {
		echo "
			<script>
				alert('Данные модуля объявлений успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
		exit();
	}