<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/config.php');

    function couponsController($code, $lang_code) {
        global $db_connect, $smarty, $config;

        $coupon = $db_connect->get('coupons', '*', [
            'id'     => $code,
           // 'language'=> $lang_code
        ]);

        if (!$coupon) {
            $smarty->assign('error_message', 'Купон не найден');
            $smarty->display(TEMPLATES_DIR.'/'.$config['skin'].'/error.tpl');
            return;
        }

        $coupon['description'] = html_entity_decode(
            $coupon['description'] ?? '',
            ENT_QUOTES,
            'UTF-8'
        );

        // Заголовки
        $smarty->assign('title', 'Купон '.$coupon['code'].' - '.$config['title']);

        require_once(ENGINE_DIR . '/mods/binding_control.php');
        generateBindings("coupons", '
            <li class="breadcrumb-item"><a href="/coupons">Купоны</a></li>
            <li class="breadcrumb-item active">'.$coupon['code'].'</li>
        ');
        // Данные
        $smarty->assign('coupon', $coupon);

        $smarty->assign(
            'content',
            $smarty->fetch(
                TEMPLATES_DIR.'/'.$config['skin'].'/modules/coupons/full_coupons.tpl',
                ['coupon' => $coupon]
            )
        );

        require_once(ENGINE_DIR . '/mods/offline.php');
    }

    $smarty->assign($config);