<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

	// Удаление таблиц перед повторным созданием
	if ($db_connect->query("SHOW TABLES LIKE 'coupons'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `coupons`');
	}
	if ($db_connect->query("SHOW TABLES LIKE 'coupons_categories'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `coupons_categories`');
	}

	// Флаг для отслеживания успешности выполнения запросов
	$successFlag = true;

	// Массив с запросами на создание таблиц
	$createTables = [
		'CREATE TABLE IF NOT EXISTS coupons (
            id INT(11) NOT NULL AUTO_INCREMENT,
            code VARCHAR(64) NOT NULL,
            language VARCHAR(64) NOT NULL,
            discount_type TINYINT NOT NULL,  -- 1 процент, 2 фикс
            discount_value DECIMAL(12,2) NOT NULL DEFAULT 0.00,
            min_order_sum DECIMAL(12,2) DEFAULT 0.00,
            max_discount_sum DECIMAL(12,2) DEFAULT NULL,
            usage_limit INT DEFAULT NULL,        -- сколько раз можно использовать всего
            usage_limit_per_user INT DEFAULT NULL, -- на одного юзера
            used_count INT UNSIGNED NOT NULL DEFAULT 0,
            apply_to_all TINYINT NOT NULL DEFAULT 1, -- 1 = на всё, 0 = выборочно
            description TEXT NULL,
            status TINYINT UNSIGNED NOT NULL DEFAULT 1,  -- 1 активен, 0 выключен
            start_at DATETIME NULL,
            end_at DATETIME NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX (code),
            INDEX (discount_type),
            INDEX (status),
            INDEX (start_at),
            INDEX (end_at),
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',

		'CREATE TABLE IF NOT EXISTS `coupons_fields` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`x_name` VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
			`column_type` VARCHAR(255) NOT NULL, -- Тип столбца в таблице
			`column_length` INT DEFAULT 0, -- Длина
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

		'CREATE TABLE IF NOT EXISTS `coupons_field_values` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`coupons_id` INT(11) NOT NULL, -- ID новости
			`field_id` INT(11) NOT NULL, -- ID поля из coupons_fields
			`x_value` TEXT NOT NULL, -- Значение поля (универсальное хранилище)
			PRIMARY KEY (`id`),
			FOREIGN KEY (`coupons_id`) REFERENCES `coupons`(`id`) ON DELETE CASCADE,
			FOREIGN KEY (`field_id`) REFERENCES `coupons_fields`(`id`) ON DELETE CASCADE
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

		'CREATE TABLE IF NOT EXISTS `coupons_categories` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			`parentid` INT(11) DEFAULT NULL,
			`position` INT(11) DEFAULT NULL,
    		`language` VARCHAR(190) DEFAULT NULL,
			`name` VARCHAR(50) DEFAULT NULL,
			`alt_name` VARCHAR(50) DEFAULT NULL,
			`meta_desc` VARCHAR(300) DEFAULT NULL,
			`meta_keys` TEXT DEFAULT NULL,
			`short_tpl` VARCHAR(40) DEFAULT NULL,
			`full_tpl` VARCHAR(40) DEFAULT NULL,
			`comments` TINYINT(1) DEFAULT NULL,
			`views` INT DEFAULT 0,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

		'CREATE TABLE IF NOT EXISTS `coupons_participants` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор записи
			`coupons_title` VARCHAR(255) DEFAULT NULL, -- ID аукциона, на которое подписан участник
			`user_id` INT(11) NOT NULL, -- ID пользователя, подписанного на аукцион
			`username` VARCHAR(255) DEFAULT NULL, -- Имя пользователя
			`phone` VARCHAR(20) DEFAULT NULL, -- Телефон пользователя
			`social_url` VARCHAR(255) DEFAULT NULL, -- Сссылка на страницу в соц сети
			`registration_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время подписки на аукцион
			`status` VARCHAR(50) DEFAULT NULL, -- Статус подписки (например: pending, confirmed, cancelled)
			`ip` VARCHAR(45) DEFAULT NULL, -- IP-адрес пользователя
			`city` VARCHAR(255) DEFAULT NULL, -- Город пользователя
			`notes` TEXT DEFAULT NULL, -- Дополнительные заметки о подписке
			PRIMARY KEY (`id`) -- Основной ключ
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

        'CREATE TABLE IF NOT EXISTS `coupon_items` (
            id INT(11) NOT NULL AUTO_INCREMENT,
            coupon_id INT(11) NOT NULL,
            module_id INT(11) NOT NULL,   -- твой товар/аукцион
            module_name VARCHAR(50) DEFAULT NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            INDEX (coupon_id),
            INDEX (module_id),
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',

        'CREATE TABLE IF NOT EXISTS `coupons_cat_relations` (
            `coupons_id` INT NOT NULL,
            `category_id` INT NOT NULL,
            PRIMARY KEY (`coupons_id`, `category_id`),
            CONSTRAINT `fk_coupons`
                FOREIGN KEY (`coupons_id`) REFERENCES `coupons`(`id`)
                ON DELETE CASCADE
                ON UPDATE CASCADE,
            CONSTRAINT `fkcoupons_category`
                FOREIGN KEY (`category_id`) REFERENCES `coupons_categories`(`id`)
                ON DELETE CASCADE
                ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;',


	];

	// Выполняем запросы на создание таблиц
	foreach ($createTables as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}


    // Пример массива купонов
    $coupons = [
        [
            'code' => 'WELCOME10',
            'discount_type' => 1,
            'discount_value' => 10.00,
            'min_order_sum' => 50.00,
            'max_discount_sum' => 100.00,
            'usage_limit' => 500,
            'usage_limit_per_user' => 1,
            'used_count' => 0,
            'apply_to_all' => 1,
            'description' => 'Скидка на первый заказ',
            'status' => 1,
            'start_at' => '2025-11-01 00:00:00',
            'end_at' => '2025-12-31 23:59:59',
            'created_at' => '2025-11-01 10:00:00',
            'updated_at' => '2025-11-01 10:00:00'
        ],
        [
            'code' => 'BLACKFRIDAY50',
            'discount_type' => 2,
            'discount_value' => 50.00,
            'min_order_sum' => 200.00,
            'max_discount_sum' => null,
            'usage_limit' => 100,
            'usage_limit_per_user' => 1,
            'used_count' => 0,
            'apply_to_all' => 0,
            'description' => 'Черная пятница',
            'status' => 1,
            'start_at' => '2025-11-25 00:00:00',
            'end_at' => '2025-11-30 23:59:59',
            'created_at' => '2025-11-01 10:00:00',
            'updated_at' => '2025-11-01 10:00:00'
        ]
    ];

    foreach ($coupons as $data) {
        $db_connect->insert('coupons', $data);
    }

/*
    // Пример массива для coupon_items
    $coupon_items = [
        [
            'id' => 1,
            'coupon_id' => 1,
            'module_id' => 101,
            'module_name' => 'Товар A',
            'created_at' => '2025-11-01 10:05:00'
        ],
        [
            'id' => 2,
            'coupon_id' => 2,
            'module_id' => 202,
            'module_name' => 'Аукцион B',
            'created_at' => '2025-11-01 10:10:00'
        ]
    ];*/


// Проверяем флаг и выводим сообщение
	if ($successFlag) {
		echo "
			<script>
				alert('Данные модуля новостей успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
		exit();
	}