<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Устанавливаем массив для передачи данных в шаблон
    require_once(ENGINE_DIR . '/data/config.php');

    function allCouponsController($lang_code) {
        global $db_connect, $smarty, $config, $lang;

        // Получаем текущую страницу из URL или устанавливаем ее в 1, если отсутствует
        $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;

        // Рассчитываем начальную точку для запроса на основе пагинации
        $start = ($currentPage - 1) * $config['modules']['coupons']['coupons_per_page'];

        $moduleName = "coupons";

        require_once ENGINE_DIR . '/mods/module_condition_data.php';
        $couponsList = getFilterDataList($moduleName, null, $start, [
            "n.code", "n.discount_value", "n.discount_type", "n.description"
        ], null, null, [
            "n.language", "n.title", "n.image", "n.short_desc", "n.full_desc", "n.alt_name", "n.views"
        ]);

        $currentCurrency = getCurrentCurrency();
        $baseCurrency = $config['payment_info']['default_currency'];
        $baseRate = $config['payment_info']['currencies'][$baseCurrency];
        $currentRate = $config['payment_info']['currencies'][$currentCurrency];
      /*  foreach ($couponsList as &$ad) {
            $ad['converted_price'] = convertPrice($ad['price'], $baseCurrency, $currentCurrency, $baseRate, $currentRate);
        }*/
        require_once ENGINE_DIR . '/mods/get_module_categories.php';

        // Для каждого объявления получаем категории и их alt_name
        foreach ($couponsList as $key => &$ad) {
            require_once ENGINE_DIR . '/mods/access_control.php';
            $isPermitted = checkAssess((int)$ad["id"], "coupons");
            if (!$isPermitted) {
                unset($couponsList[$key]);
                continue;
            }

            $ad['category_alt_names'] = getCategoriesAltNames($ad['id'], "coupons");
            $categories = getCategoriesList($ad['id'], "coupons");

            // Декодируем описания объявления
            if (!empty($ad['short_desc'])) {
                $ad['short_desc'] = html_entity_decode($ad['short_desc'], ENT_QUOTES, 'UTF-8');
            }

            if (!empty($ad['full_desc'])) {
                $ad['full_desc'] = html_entity_decode($ad['full_desc'], ENT_QUOTES, 'UTF-8');
            }
        }
        $categoriesDataList = getModuleCategoriesDataList($moduleName);


        // Функция для подсчета общего числа объявлений с учетом языка
        function countCoupons($lang_code) {
            global $db_connect;
            $count = $db_connect->count('coupons', [
                'language' => $lang_code
            ]);

            return $count;
        }

        // Рассчитываем количество страниц для пагинации
        $totalPages = ceil(countCoupons($lang_code) / $config['modules']['coupons']['coupons_per_page']);
        require_once(ENGINE_DIR . '/mods/pagination.php');

        // Передаем данные в Smarty
        $smarty->assign('categoriesDataList', $categoriesDataList);
        $smarty->assign('title', 'Купоны - ' . $config['title']);

        require_once(ENGINE_DIR . '/mods/binding_control.php');
        generateBindings("coupons", '<li class="breadcrumb-item active">Купоны</li>');

        $smarty->assign('currentPage', $currentPage);
        $smarty->assign('totalPages', $totalPages);
        $smarty->assign('pagination', generatePagination($currentPage, $totalPages));
        $smarty->assign('currentCurrency', $currentCurrency);
        $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/coupons/' . $config['modules']['coupons']['short_tpl'], ['couponsList' => $couponsList]));

        // Проверяем, выключен ли сайт
        require_once(ENGINE_DIR . '/mods/offline.php');
    }

    $smarty->assign($config);