<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/dbconfig.php');
$successFlag = true;

$enabledDatabase = $config["database_settings"]["enabled_database"];
$currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

if ($enabledDatabase == "pgsql") {
    $db_connect->query("CREATE TABLE IF NOT EXISTS events (
        id SERIAL PRIMARY KEY,
        autor VARCHAR(40) DEFAULT NULL,
        date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        language VARCHAR(190) DEFAULT NULL,
        title VARCHAR(255) DEFAULT NULL,
        image VARCHAR(255) DEFAULT NULL,
        alt_name VARCHAR(190) DEFAULT NULL,
        short_desc TEXT DEFAULT NULL,
        full_desc TEXT DEFAULT NULL,
        price NUMERIC(10, 2) NOT NULL,
        start_date TIMESTAMP DEFAULT NULL,
        end_date TIMESTAMP DEFAULT NULL,
        location VARCHAR(255) DEFAULT NULL,
        participants INT DEFAULT NULL,
        capacity INT DEFAULT NULL,
        status VARCHAR(50) DEFAULT NULL,
        performers VARCHAR(1000) DEFAULT NULL,
        meta_desc VARCHAR(300) DEFAULT NULL,
        meta_keys TEXT DEFAULT NULL,
        allow_comments BOOLEAN DEFAULT NULL,
        fixed BOOLEAN DEFAULT NULL,
        allow_br BOOLEAN DEFAULT NULL,
        tags VARCHAR(255) DEFAULT NULL,
        rating INT DEFAULT NULL,
        views INT DEFAULT 0
    )");

    $db_connect->query("CREATE TABLE IF NOT EXISTS events_fields (
        id SERIAL PRIMARY KEY,
        x_name VARCHAR(255) NOT NULL,
        column_type VARCHAR(255) NOT NULL,
        column_length INT DEFAULT 0
    )");

    $db_connect->query("CREATE TABLE IF NOT EXISTS events_field_values (
        id SERIAL PRIMARY KEY,
        events_id INT NOT NULL REFERENCES events(id) ON DELETE CASCADE,
        field_id INT NOT NULL REFERENCES events_fields(id) ON DELETE CASCADE,
        x_value TEXT NOT NULL
    )");

    $db_connect->query("CREATE TABLE IF NOT EXISTS events_categories (
        id SERIAL PRIMARY KEY,
        parentid INT DEFAULT NULL,
        position INT DEFAULT NULL,
        language VARCHAR(190) DEFAULT NULL,
        name VARCHAR(50) DEFAULT NULL,
        alt_name VARCHAR(50) DEFAULT NULL,
        meta_desc VARCHAR(300) DEFAULT NULL,
        meta_keys TEXT DEFAULT NULL,
        short_tpl VARCHAR(40) DEFAULT NULL,
        full_tpl VARCHAR(40) DEFAULT NULL,
        comments BOOLEAN DEFAULT NULL,
        views INT DEFAULT 0
    )");

    $db_connect->query("CREATE TABLE IF NOT EXISTS event_participants (
        id SERIAL PRIMARY KEY,
        event_title VARCHAR(255) DEFAULT NULL,
        user_id INT NOT NULL,
        username VARCHAR(255) DEFAULT NULL,
        phone VARCHAR(20) DEFAULT NULL,
        social_url VARCHAR(255) DEFAULT NULL,
        registration_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        status VARCHAR(50) DEFAULT NULL,
        ip VARCHAR(45) DEFAULT NULL,
        city VARCHAR(255) DEFAULT NULL,
        notes TEXT DEFAULT NULL
    )");

    $db_connect->query('CREATE TABLE IF NOT EXISTS events_cat_relations (
        events_id INT NOT NULL,
        category_id INT NOT NULL,
        PRIMARY KEY (events_id, category_id),
        CONSTRAINT fk_events
            FOREIGN KEY (events_id) REFERENCES events(id)
            ON DELETE CASCADE
            ON UPDATE CASCADE,
        CONSTRAINT fke_category
            FOREIGN KEY (category_id) REFERENCES events_categories(id)
            ON DELETE CASCADE
            ON UPDATE CASCADE
    )');
}


$createTablesMySQL = [
    'CREATE TABLE IF NOT EXISTS `events` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор мероприятия
			`autor` VARCHAR(40) DEFAULT NULL, -- Автор, создавший мероприятие
			`date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания записи мероприятия
			`language` VARCHAR(190) DEFAULT NULL, -- Язык мероприятия
			`title` VARCHAR(255) DEFAULT NULL, -- Название мероприятия
			`image` VARCHAR(255) DEFAULT NULL, -- Ссылка на изображение мероприятия
			`alt_name` VARCHAR(190) DEFAULT NULL, -- Альтернативное имя (URL)
			`short_desc` MEDIUMTEXT DEFAULT NULL, -- Краткое описание мероприятия
			`full_desc` MEDIUMTEXT DEFAULT NULL, -- Полное описание мероприятия
			`price` DECIMAL(10, 2) NOT NULL, -- Стоимость участия в мероприятии
			`start_date` TIMESTAMP DEFAULT NULL, -- Дата и время начала мероприятия
			`end_date` TIMESTAMP DEFAULT NULL, -- Дата и время окончания мероприятия (если применимо)
			`location` VARCHAR(255) DEFAULT NULL, -- Местоположение проведения мероприятия
			`participants` INT DEFAULT NULL, -- Количество подписанных участников
			`capacity` INT DEFAULT NULL, -- Максимальное количество участников
			`status` VARCHAR(50) DEFAULT NULL, -- Статус мероприятия (например: Open, Closed, Completed)
			`performers` VARCHAR(1000) DEFAULT NULL, -- Список исполнителей мероприятия (разделённых запятой)
			`meta_desc` VARCHAR(300) DEFAULT NULL, -- Мета-описание для SEO
			`meta_keys` TEXT DEFAULT NULL, -- Мета-ключевые слова для SEO
			`allow_comments` TINYINT(1) DEFAULT NULL, -- Флаг, разрешающий комментарии (0 или 1)
			`fixed` TINYINT(1) DEFAULT NULL, -- Флаг, указывающий на фиксированное положение мероприятия (например, для закрепления в списке)
			`allow_br` TINYINT(1) DEFAULT NULL, -- Флаг, разрешающий использование <br> в описании мероприятия
			`tags` VARCHAR(255) DEFAULT NULL, -- Теги мероприятия (разделены запятыми)
			`rating` TINYINT DEFAULT NULL, -- Рейтинг мероприятия (от 1 до 10 или другая шкала)
			`views` INT DEFAULT 0, -- Количество просмотров мероприятия
			PRIMARY KEY (`id`) -- Основной ключ (уникальный идентификатор)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `events_fields` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`x_name` VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
			`column_type` VARCHAR(255) NOT NULL, -- Тип столбца в таблице
			`column_length` INT DEFAULT 0, -- Длина
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `events_field_values` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`events_id` INT(11) NOT NULL, -- ID новости
			`field_id` INT(11) NOT NULL, -- ID поля из events_fields
			`x_value` TEXT NOT NULL, -- Значение поля (универсальное хранилище)
			PRIMARY KEY (`id`),
			FOREIGN KEY (`events_id`) REFERENCES `events`(`id`) ON DELETE CASCADE,
			FOREIGN KEY (`field_id`) REFERENCES `events_fields`(`id`) ON DELETE CASCADE
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `events_categories` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			`parentid` INT(11) DEFAULT NULL,
			`position` INT(11) DEFAULT NULL,
    		`language` VARCHAR(190) DEFAULT NULL,
			`name` VARCHAR(50) DEFAULT NULL,
			`alt_name` VARCHAR(50) DEFAULT NULL,
			`meta_desc` VARCHAR(300) DEFAULT NULL,
			`meta_keys` TEXT DEFAULT NULL,
			`short_tpl` VARCHAR(40) DEFAULT NULL,
			`full_tpl` VARCHAR(40) DEFAULT NULL,
			`comments` TINYINT(1) DEFAULT NULL,
			`views` INT DEFAULT 0,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `event_participants` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор записи
			`event_title` VARCHAR(255) DEFAULT NULL, -- ID мероприятия, на которое подписан участник
			`user_id` INT(11) NOT NULL, -- ID пользователя, подписанного на мероприятие
			`username` VARCHAR(255) DEFAULT NULL, -- Имя пользователя
			`phone` VARCHAR(20) DEFAULT NULL, -- Телефон пользователя
			`social_url` VARCHAR(255) DEFAULT NULL, -- Сссылка на страницу в соц сети
			`registration_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время подписки на мероприятие
			`status` VARCHAR(50) DEFAULT NULL, -- Статус подписки (например: pending, confirmed, cancelled)
			`ip` VARCHAR(45) DEFAULT NULL, -- IP-адрес пользователя
			`city` VARCHAR(255) DEFAULT NULL, -- Город пользователя
			`notes` TEXT DEFAULT NULL, -- Дополнительные заметки о подписке
			PRIMARY KEY (`id`) -- Основной ключ
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `events_cat_relations` (
        `events_id` INT NOT NULL,
        `category_id` INT NOT NULL,
        PRIMARY KEY (`events_id`, `category_id`),
        CONSTRAINT `fk_events`
            FOREIGN KEY (`events_id`) REFERENCES `events`(`id`)
            ON DELETE CASCADE
            ON UPDATE CASCADE,
        CONSTRAINT `fke_category`
            FOREIGN KEY (`category_id`) REFERENCES `events_categories`(`id`)
            ON DELETE CASCADE
            ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;'
];

if ($enabledDatabase == "mysql") {
    foreach ($createTablesMySQL as $sql) {
        if ($db_connect->query($sql) !== TRUE) {
            echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
            $successFlag = false;
        }
    }
}


// Массив с запросами на добавление данных в таблицы
$addData = [
    'events' => [
        'autor' => 'Admin',
        'date' => 'NOW()',
        'language' => 'English',
        'title' => 'Science Event',
        'image' => 'uploads/images/events/1.png',
        'alt_name' => 'science-event',
        'short_desc' => 'Short description of the test event.',
        'full_desc' => 'Full description of the test event.',
        'price' => 1200000.00,
        'start_date' => '2024-11-01 18:00:00',
        'end_date' => '2024-11-01 22:00:00',
        'location' => 'New York City',
        'participants' => 0,
        'capacity' => 40,
        'status' => 'upcoming',
        'performers' => 'Performer 1, Performer 2, Performer 3, Performer 4',
        'meta_desc' => '',
        'meta_keys' => '',
        'allow_comments' => 1,
        'fixed' => 0,
        'allow_br' => 1,
        'tags' => '',
        'rating' => 0,
        'views' => 0
    ],
    'events_categories' => [
        'parentid' => 0,
        'position' => 1,
        'language' => 'English',
        'name' => 'Science',
        'alt_name' => 'science',
        'meta_desc' => '',
        'meta_keys' => '',
        'short_tpl' => 'short_tpl_default',
        'full_tpl' => 'full_tpl_default',
        'comments' => 0,
        'views' => 0
    ],
    'events_fields' => [
        'x_name' => 'source_url',
        'column_type' => 'VARCHAR',
        'column_length' => 255
    ],
    'events_field_values' => [
        'events_id' => 1,
        'field_id' => 1,
        'x_value' => 'https://example.com'
    ]
];

// Выполнение запросов на добавление данных
foreach ($addData as $table => $data) {
    try {
        $db_connect->insert($table, $data);
    } catch (Exception $e) {
        echo "Ошибка при добавлении данных в таблицу $table: " . $e->getMessage() . "\n";
        $successFlag = false;
    }
}

$event_category = [
    'parentid' => 0,
    'position' => 1,
    'language' => 'English',
    'name' => 'Science',
    'alt_name' => 'science',
    'meta_desc' => '',
    'meta_keys' => '',
    'short_tpl' => 'short_tpl_default',
    'full_tpl' => 'full_tpl_default',
    'comments' => 0,
    'views' => 0
];

// Вставка данных в таблицу `events_categories`
$db_connect->insert('events_categories', $event_category);

// Проверяем флаг и выводим сообщение
if ($successFlag) {
    echo "
            <script>
                alert('Данные модуля новостей успешно добавлены');
                window.location.href = window.location.href;
            </script>
        ";
    exit();
}