<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Подключаем файл с массивом данных для передачи в шаблон
    require_once(ENGINE_DIR . '/data/config.php');
    
    function allFilesController($lang_code) {
        global $db_connect, $smarty, $config, $lang;
    
        // Получаем текущую страницу из URL или устанавливаем ее в 1, если не указана
        $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
    
        // Рассчитываем начальную точку для запроса на основе пагинации
        $start = ($currentPage - 1) * $config['modules']['files']['files_per_page'];

        require_once ENGINE_DIR . '/mods/module_condition_data.php';
        $filesList = getFilterDataList("files", $lang_code, $start, [
            "n.date"
        ]);

        require_once ENGINE_DIR . '/mods/get_module_categories.php';

        // Для каждого файла получаем категории и их alt_name
        foreach ($filesList as $key => &$file) {
            require_once ENGINE_DIR . '/mods/access_control.php';
            $isPermitted = checkAssess((int)$file["id"], "files");
            if (!$isPermitted) {
                unset($filesList[$key]);
                continue;
            }

            $file['category_alt_names'] = getCategoriesAltNames($file['id'], "files");
            $categories = getCategoriesList($file['id'], "files");
    
            // Декодируем описания файла
            if (!empty($file['short_desc'])) {
                $file['short_desc'] = html_entity_decode($file['short_desc'], ENT_QUOTES, 'UTF-8');
            }
    
            if (!empty($file['full_desc'])) {
                $file['full_desc'] = html_entity_decode($file['full_desc'], ENT_QUOTES, 'UTF-8');
            }
        }
        $categoriesDataList = getModuleCategoriesDataList("files");


        // Рассчитываем количество страниц для пагинации
        $totalPages = ceil(countFiles($lang_code) / $config['modules']['files']['files_per_page']);
        require_once(ENGINE_DIR . '/mods/pagination.php');
    
        // Передаем данные в Smarty
        $smarty->assign('categoriesDataList', $categoriesDataList);
        $smarty->assign('title', $lang['module_name']['files'] . ' - ' . $config['title']);

        require_once(ENGINE_DIR . '/mods/binding_control.php');
        generateBindings("files", '<li class="breadcrumb-item active">' . $lang['module_name']['files'] . '</li>');

        $smarty->assign('currentPage', $currentPage);
        $smarty->assign('totalPages', $totalPages);
        $smarty->assign('pagination', generatePagination($currentPage, $totalPages));
        $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/files/' . $config['modules']['files']['short_tpl'], ['filesList' => $filesList]));
    
        // Проверяем, выключен ли сайт
        require_once(ENGINE_DIR . '/mods/offline.php');
    }
    
    // Функция для подсчета общего количества файлов с фильтрацией по языку
    function countFiles($lang_code) {
        global $db_connect;

        $count = $db_connect->count('files', [
            'language' => $lang_code
        ]);

        return $count;
    }
    
    $smarty->assign($config);