<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

	// Удаление таблиц перед повторным созданием
	if ($db_connect->query("SHOW TABLES LIKE 'ads'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `ads`');
	}
	if ($db_connect->query("SHOW TABLES LIKE 'ads_categories'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `ads_categories`');
	}

	// Флаг для отслеживания успешности выполнения запросов
	$successFlag = true;

	// Массив с запросами на создание таблиц
	$createTables = [
		'CREATE TABLE IF NOT EXISTS `example` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',
	];

	// Выполняем запросы на создание таблиц
	foreach ($createTables as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}

	// Массив с запросами на добавление данных в таблицы
	$addData = [
		// Добавление данных в таблицу `ads`
		"INSERT INTO `example` (`id`) VALUES (1)",
	];

	// Выполнение запросов
	foreach ($addData as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}

	// Проверяем флаг и выводим сообщение
	if ($successFlag) {
		echo "
			<script>
				alert('Данные модуля объявлений успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
		exit();
	}