<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

	// Удаление таблиц перед повторным созданием
	if ($db_connect->query("SHOW TABLES LIKE 'lots'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `lots`');
	}
	if ($db_connect->query("SHOW TABLES LIKE 'lots_categories'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `lots_categories`');
	}

	// Флаг для отслеживания успешности выполнения запросов
	$successFlag = true;

	// Массив с запросами на создание таблиц
	$createTables = [
		'CREATE TABLE IF NOT EXISTS `lots` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор аукциона
			`author` VARCHAR(40) DEFAULT NULL, -- Автор, создавший аукцион
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания записи аукциона
			`category` VARCHAR(255) DEFAULT NULL, -- Категория аукциона
			`language` VARCHAR(190) DEFAULT NULL, -- Язык мероприятия
			`title` VARCHAR(255) NOT NULL, -- Название аукциона
			`alt_name` VARCHAR(190) DEFAULT NULL, -- Альтернативное имя (URL)
			`image` VARCHAR(255) DEFAULT NULL, -- Ссылка на изображение товара
			`short_desc` MEDIUMTEXT DEFAULT NULL, -- Краткое описание мероприятия
			`full_desc` MEDIUMTEXT DEFAULT NULL, -- Полное описание мероприятия
			`start_price` DECIMAL(10, 2) NOT NULL, -- Начальная цена
			`current_price` DECIMAL(10, 2) DEFAULT NULL, -- Текущая цена
			`buy_now_price` DECIMAL(10, 2) DEFAULT NULL, -- Цена "Купить сейчас"
			`start_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время начала аукциона
			`end_date` TIMESTAMP DEFAULT NULL, -- Дата и время окончания аукциона
			`participants` INT DEFAULT NULL, -- Количество подписанных участников
			`capacity` INT DEFAULT NULL, -- Максимальное количество участников
			`status` VARCHAR(50) DEFAULT NULL, -- Статус аукциона (active, completed, canceled)
			`winner` VARCHAR(40) DEFAULT NULL, -- Победитель аукциона
			`bids_count` INT DEFAULT 0, -- Количество ставок
			`views` INT DEFAULT 0, -- Количество просмотров
			`tags` VARCHAR(255) DEFAULT NULL, -- Теги (разделенные запятыми)
			`meta_desc` VARCHAR(300) DEFAULT NULL, -- Мета-описание для SEO
			`meta_keys` TEXT DEFAULT NULL, -- Мета-ключевые слова для SEO
			PRIMARY KEY (`id`) -- Основной ключ
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

		'CREATE TABLE IF NOT EXISTS `lots_fields` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`x_name` VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
			`column_type` VARCHAR(255) NOT NULL, -- Тип столбца в таблице
			`column_length` INT DEFAULT 0, -- Длина
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

		'CREATE TABLE IF NOT EXISTS `lots_field_values` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`lots_id` INT(11) NOT NULL, -- ID новости
			`field_id` INT(11) NOT NULL, -- ID поля из lots_fields
			`x_value` TEXT NOT NULL, -- Значение поля (универсальное хранилище)
			PRIMARY KEY (`id`),
			FOREIGN KEY (`lots_id`) REFERENCES `lots`(`id`) ON DELETE CASCADE,
			FOREIGN KEY (`field_id`) REFERENCES `lots_fields`(`id`) ON DELETE CASCADE
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

		'CREATE TABLE IF NOT EXISTS `lots_categories` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			`parentid` INT(11) DEFAULT NULL,
			`position` INT(11) DEFAULT NULL,
    		`language` VARCHAR(190) DEFAULT NULL,
			`name` VARCHAR(50) DEFAULT NULL,
			`alt_name` VARCHAR(50) DEFAULT NULL,
			`meta_desc` VARCHAR(300) DEFAULT NULL,
			`meta_keys` TEXT DEFAULT NULL,
			`short_tpl` VARCHAR(40) DEFAULT NULL,
			`full_tpl` VARCHAR(40) DEFAULT NULL,
			`comments` TINYINT(1) DEFAULT NULL,
			`views` INT DEFAULT 0,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

		'CREATE TABLE IF NOT EXISTS `lots_participants` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор записи
			`lots_title` VARCHAR(255) DEFAULT NULL, -- ID аукциона, на которое подписан участник
			`user_id` INT(11) NOT NULL, -- ID пользователя, подписанного на аукцион
			`username` VARCHAR(255) DEFAULT NULL, -- Имя пользователя
			`phone` VARCHAR(20) DEFAULT NULL, -- Телефон пользователя
			`social_url` VARCHAR(255) DEFAULT NULL, -- Сссылка на страницу в соц сети
			`registration_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время подписки на аукцион
			`status` VARCHAR(50) DEFAULT NULL, -- Статус подписки (например: pending, confirmed, cancelled)
			`ip` VARCHAR(45) DEFAULT NULL, -- IP-адрес пользователя
			`city` VARCHAR(255) DEFAULT NULL, -- Город пользователя
			`notes` TEXT DEFAULT NULL, -- Дополнительные заметки о подписке
			PRIMARY KEY (`id`) -- Основной ключ
		) ENGINE=INNODB DEFAULT CHARSET=utf8',		
	];

	// Выполняем запросы на создание таблиц
	foreach ($createTables as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}

	// Массив с запросами на добавление данных в таблицы
	$addData = [
		// Добавление данных в таблицу `lots`
		"INSERT INTO `lots` (`author`, `category`, `language`, `title`, `alt_name`, `image`, `short_desc`, `full_desc`, `start_price`, `current_price`, `buy_now_price`, `start_date`, `end_date`, `participants`, `capacity`, `status`, `tags`, `meta_desc`, `meta_keys`) VALUES ('user1', 'Electronics', 'Russian', 'Smartphone XYZ', 'lot-1', 'uploads/images/lots/2024/12/smartphone-xyz.jpg', 'Краткое описание лота', 'Полное описание лота', 299.99, NULL, 399.99, NOW(), DATE_ADD(NOW(), INTERVAL 7 DAY), 0, 40, 'active', 'smartphone, electronics, gadget', 'Buy a brand-new smartphone XYZ at lots!', 'smartphone, lots, electronics')",

		"INSERT INTO `lots` (`author`, `category`, `language`, `title`, `alt_name`, `image`, `short_desc`, `full_desc`, `start_price`, `current_price`, `buy_now_price`, `start_date`, `end_date`, `participants`, `capacity`, `status`, `tags`, `meta_desc`, `meta_keys`) VALUES ('user2', 'Home Appliances', 'Russian', 'Vacuum Cleaner Pro', 'lot-2', 'uploads/images/lots/2024/12/vacuum-cleaner-pro.jpg', 'Краткое описание лота', 'Полное описание лота', 99.99, NULL, 149.99, NOW(), DATE_ADD(NOW(), INTERVAL 5 DAY), 0, 40, 'active', 'vacuum cleaner, home appliances, cleaning', 'Get the best vacuum cleaner at the best price!', 'vacuum cleaner, home, lots')",	

		// Добавление данных в таблицу `lots_categories`
		"INSERT INTO `lots_categories` (`id`, `parentid`, `position`, `language`, `name`, `alt_name`, `meta_desc`, `meta_keys`, `short_tpl`, `full_tpl`, `comments`, `views`) VALUES (1, 0, 1, 'Russian', 'Electronics', 'electronics', '', '', 'short_tpl_default', 'full_tpl_default', 0, 0)",
		"INSERT INTO `lots_categories` (`id`, `parentid`, `position`, `language`, `name`, `alt_name`, `meta_desc`, `meta_keys`, `short_tpl`, `full_tpl`, `comments`, `views`) VALUES (2, 0, 1, 'Russian', 'Home Appliances', 'home-appliances', '', '', 'short_tpl_default', 'full_tpl_default', 0, 0)",

		// Добавление дополнительного поля в таблицу `lots_fields`
		"INSERT INTO `lots_fields` (`x_name`, `column_type`, `column_length`) VALUES ('source_url', 'VARCHAR', 255)",

		// Добавление значения дополнительного поля в таблицу `lots_field_values`
		"INSERT INTO `lots_field_values` (`lots_id`, `field_id`, `x_value`) VALUES (1, (SELECT `id` FROM `lots_fields` WHERE `x_name` = 'source_url'), 'https://example.com')",
	];

	// Выполнение запросов
	foreach ($addData as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}

	// Проверяем флаг и выводим сообщение
	if ($successFlag) {
		echo "
			<script>
				alert('Данные модуля новостей успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
		exit();
	}