<?php

    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    function addObjectLotController()
    {
        global $smarty, $config, $db_connect, $lang, $user_authenticated;

        $user = $db_connect->get("users", "*", ["email" => $_SESSION["user_email"] ?? null]);

        if (!$user) {
            // Пользователь не найден
            $smarty->assign('error_message', 'У вас нет доступа к этой странице');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
        } else {

            $module_entity = "lots";
            require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

            $categories = [];
            $result = $db_connect->select("lots_categories", "*") ?? [];
            if (!empty($result["id"])) {
                $categories[] = $result;
            } else {
                foreach ($result as $row) {
                    $categories[] = $row;
                }
            }

            $error_message = '';

            // Обработка формы добавления файла
            if (isset($_POST['addlot'])) {
                $folder = $_POST['folder'] ?? '';
                $p_id = (int)$db_connect->max("lots", "id") + 1;

                // Подготовка запроса на добавление в таблицу lots_field_values
                $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
                $field_ids = $_POST['field_ids'] ?? [];
                $lots_id = $p_id;

                // Проверка загруженного изображения (не в редакторе)
                require_once(ENGINE_DIR . '/mods/check_upload_image.php');

                // Получаем данные из формы
                $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
                $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
                $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
                $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
                $title = strip_tags(trim($_POST['title']));
                $alt_name = strip_tags(trim($_POST['alt_name']));
                $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
                $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);

                $start_date = isset($_POST['start_date']) && !empty($_POST['start_date']) ? strip_tags(trim($_POST['start_date'])) : date($config['date_format']);
                $end_date = isset($_POST['end_date']) && !empty($_POST['end_date']) ? strip_tags(trim($_POST['end_date'])) : date($config['date_format']);
                $capacity = isset($_POST['capacity']) ? (is_array($_POST['capacity']) ? implode(', ', $_POST['capacity']) : $_POST['capacity']) : '';
                $status = isset($_POST['status']) ? (is_array($_POST['status']) ? implode(', ', $_POST['status']) : $_POST['status']) : '';

                $meta_desc = strip_tags(trim($_POST['meta_desc']));
                $meta_keys = strip_tags(trim($_POST['meta_keys']));
                $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

                // Проверяем, было ли загружено изображение
                if (empty($image)) {$error_message .= "Изображение не загружено.<br>";}
                // Проверяем, содержит ли URL запрещённые символы
                $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
                if ($forbidden_char_found) {
                    // Если найден запрещённый символ, создаём сообщение об ошибке
                    $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
                    $smarty->assign('error_message', $error_message);
                }
                // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
                elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
                    // Если URL зарезервирован, создаём сообщение об ошибке
                    $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
                    $smarty->assign('error_message', $error_message);
                } elseif (empty($error_message)) {
                    $result = $db_connect->insert("lots", [
                        "author" => $autor,
                        "language" => $language == "" ? $_SESSION['lang'] : $language,
                        "title" => $title,
                        "short_desc" => $short_desc,
                        "full_desc" => $full_desc,
                        "start_date" => $start_date,
                        "end_date" => $end_date,
                        "capacity" => $capacity,
                        "status" => $status,
                        "meta_desc" => $meta_desc,
                        "meta_keys" => $meta_keys,
                        "views" => $views,
                        "start_price" => 0,
                        "current_price" => 0,
                        "buy_now_price" => 0,
                        "alt_name" => $alt_name,
                        "image" => $image,
                    ]);

                    $lots_id = $db_connect->id();

                    if (!empty($_POST["category"])) {
                        foreach ($_POST["category"] as $categoryId) {
                            $db_connect->insert("lots_cat_relations", [
                                "lots_id" => (int)$lots_id,
                                "category_id" => (int)$categoryId,
                            ]);
                        }
                    }


                    require_once ENGINE_DIR . '/mods/access_control.php';
                    saveAccessSettings((int)$lots_id, "lots", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

                    if (!empty($field_ids)) {
                        foreach ($field_ids as $field_id) {
                            if (!empty($_POST['x_value'][$field_id])) {
                                $insertField = $db_connect->insert("lots_field_values", [
                                    "lots_id" => $lots_id,
                                    "field_id" => $field_id,
                                    "x_value" => $_POST['x_value'][$field_id]
                                ]);
                            }
                        }
                    }
                    if ($lots_id) {
                        header("Location: /lots");
                        exit();
                    } else {
                        $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
                    }
                }
            }


            $lastRow = $db_connect->get("lots", ['id'], [
                "ORDER" => ["id" => "DESC"] // Сортировка по убыванию id
            ]);

            require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
            $smarty->assign("selectedModuleAdd", $module_entity);

            $smarty->assign('title', 'Add lots - MDS');
            $smarty->assign('page_name', '
                            <li class="breadcrumb-item active"><a href="/lots">Lots</a></li>
                        ');
            $smarty->assign('add_page', 'add_page');
            $smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
            $smarty->assign('max_id', 0 + 1);
            /*        $smarty->assign('theme', SYSTEM_DIR);*/
            $smarty->assign('config', $config);
            $smarty->assign('categories', $categories);
            /*        $smarty->assign('error_message', $error_message);*/
            $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/lots/add.tpl'));
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/main.tpl');

            exit;

        }
    }